ORCA/M Asm65816 2.1.0

0001 6782                       TITLE 'Pseudo MovInv Ram Test'
0002 6782
0003 6782              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 6782              ;	by EdAsmCvtIIGS version 1.2d7 on 5/14/91 at 7:15:58 PM
0005 6782
0006 6782              ***********************************************************************
0007 6782              * file: moviram
0008 6782              *
0009 6782              * 16 bit version of popular //e Ramtest of the 80's
0010 6782              *
0011 6782              * Revision History:
0012 6782              *
0013 6782              * 11 sep 85    RCarr    New Today
0014 6782              * 16 sep 85    RCarr    Converted to use indirect long addressing
0015 6782              * 05 dec 85    RCarr    Added to DVT test, make seg unrelated
0016 6782              * XX Jan 86    KG       Added to internal diags...
0017 6782              * 20 mar 86    RCarr    Improve Error Reporting and code krunch 1
0018 6782              * 06 Apr 88    BS Soh   Expand to 1 M for Rev.D
0019 6782              *
0020 6782              * Data 8 , Data bank =0
0021 6782                                                      ; SEG	$00
0022 6782              MOVIRAM  EQU   *
0023 6782 E2 30                 DATA8 
0024 6784 2C 50 C0              BIT   TXTCLR
0025 6787 2C 52 C0              BIT   MIXCLR
0026 678A 2C 57 C0              BIT   HIRES
0027 678D              *
0028 678D A2 00                 LDX   #0
0029 678F DA                    PHX                            ;save x
0030 6790              BT1      EQU   *
0031 6790              ;LDA #$C0
0032 6790              ;eor NEWVIDEO  ;Toggle between $01 & $C1
0033 6790              ;sta NEWVIDEO
0034 6790 FA                    PLX   
0035 6791 E0 04                 CPX   #4
0036 6793 F0 16                 BEQ   BTEnd                    ;Completed
0037 6795 EE 34 C0              INC   CLOCKCTL                 ;Increment into next border color
0038 6798 BF F0 70 FF           LDA   >BANKtbl,x               ;Get next Test Bank
0039 679C E8                    INX   
0040 679D DA                    PHX                            ;save x
0041 679E 20 D2 67              JSR   MoviRamTest
0042 67A1 B0 05                 BCS   BTExit
0043 67A3 20 93 68              JSR   DoZpageInd
0044 67A6 90 E8                 BCC   BT1                      ;More bank
0045 67A8 FA           BTEXIT   PLX                            ;Throuw away x
0046 67A9 80 1D                 BRA   MoviRamExit              ;fail, exit
0047 67AB              *
0048 67AB              BTEND    EQU   *
0049 67AB              ;
0050 67AB              ; Check key micro version number
0051 67AB              ;
0052 67AB 20 D8 6F              JSR   GETVERSION
0053 67AE B0 1B                 BCS   M_FDB_ERR                ;Tool had problem reading up
0054 67B0 C9 06                 CMP   #$6                      ;Is version >= 6 ?
0055 67B2 90 13                 BCC   NoMore                   ;No, it's IIgs
0056 67B4 A9 01                 LDA   #$01
0057 67B6              ;sta NEWVIDEO
0058 67B6 85 F0                 STA   RamBank
0059 67B8 E6 F0        EXPBANK  INC   RamBank
0060 67BA A5 F0                 LDA   RamBank
0061 67BC C9 10                 CMP   #$10                     ;Has it exceeded max?
0062 67BE B0 07                 BCS   NoMore                   ;Yes Exit
0063 67C0 20 06 68              JSR   MoviRamTestExp           ;Acc still contain RamBank
0064 67C3 90 F3                 BCC   ExpBank                  ;another bank
0065 67C5 80 01                 BRA   MoviRamExit
0066 67C7 18           NOMORE   CLC                            ;to be sure
0067 67C8 E2 30        MOVIRAMEXIT DATA8 
0068 67CA 6B           RAMERROR2 RTL                           ;
0069 67CB A9 FF        M_FDB_ERR LDA   #$FF
0070 67CD 8D 16 03              STA   ErrCode1
0071 67D0 38                    SEC   
0072 67D1 6B                    RTL   
0073 67D2              *
0074 67D2              MOVIRAMTEST EQU   *
0075 67D2 85 F0                 STA   RamBank
0076 67D4 C2 10                 IND16 
0077 67D6 E2 20                 MEM8 
0078 67D8 A2 00 04              LDX   #$0400
0079 67DB A0 FF BF              LDY   #$BFFF
0080 67DE 20 16 68              JSR   DoMoviTest
0081 67E1 B0 20                 BCS   FoundMoviErr
0082 67E3 AD 8B C0              LDA   lcbank1
0083 67E6 AD 8B C0              LDA   lcbank1
0084 67E9 A2 00 D0              LDX   #$d000
0085 67EC A0 FF DF              LDY   #$dfff
0086 67EF 20 16 68              JSR   DoMoviTest
0087 67F2 B0 0F                 BCS   FoundMoviErr
0088 67F4 AD 83 C0              LDA   lcbank2
0089 67F7 AD 83 C0              LDA   lcbank2
0090 67FA A2 00 D0              LDX   #$d000
0091 67FD A0 FF FF              LDY   #$ffff
0092 6800 20 16 68              JSR   DoMoviTest
0093 6803 E2 10        FOUNDMOVIERR IND8 
0094 6805 60                    RTS   
0095 6806              *
0096 6806              MOVIRAMTESTEXP EQU   *
0097 6806 C2 10                 IND16 
0098 6808 EE 34 C0              INC   CLOCKCTL                 ;Change border color
0099 680B A2 00 00              LDX   #0                       ;memory8, index16
0100 680E 9B                    TXY   
0101 680F 88                    DEY                            ;(y=$ffff) test the entire bank
0102 6810 20 16 68              JSR   DoMoviTest
0103 6813 E2 10                 IND8 
0104 6815 60                    RTS   
0105 6816              *
0106 6816                       LONGI ON
0107 6816              DOMOVITEST EQU   *
0108 6816 84 F2                 STY   RamEndAddr
0109 6818 86 F4                 STX   RamBegAddr
0110 681A A2 00 00              LDX   #$0000
0111 681D 86 04                 STX   loc
0112 681F A5 F0                 LDA   RamBank
0113 6821 85 06                 STA   loc+2
0114 6823 A9 00                 LDA   #0
0115 6825 85 07        OUTER16  STA   thedata
0116 6827 A2 02 00              LDX   #$0002
0117 682A 86 09                 STX   mod~
0118 682C A4 F4        STEPP16  LDY   RamBegAddr
0119 682E A5 07                 LDA   thedata
0120 6830 49 FF                 EOR   #$ff
0121 6832 85 0B                 STA   flip
0122 6834 97 04        STUFF16  STA   [loc],y
0123 6836 C8                    INY   
0124 6837 C4 F2                 CPY   RamEndAddr
0125 6839 90 F9                 BCC   stuff16
0126 683B A6 09                 LDX   mod~
0127 683D A4 F4                 LDY   RamBegAddr
0128 683F A5 07                 LDA   thedata
0129 6841 CA           ALT16    DEX   
0130 6842 10 05                 BPL   skip16
0131 6844 A2 02 00              LDX   #$0002
0132 6847 97 04                 STA   [loc],y
0133 6849 C8           SKIP16   INY   
0134 684A C4 F2                 CPY   RamEndAddr
0135 684C 90 F3                 BCC   alt16
0136 684E A5 09                 LDA   mod~
0137 6850 D0 08                 BNE   test16
0138 6852 A5 07                 LDA   thedata
0139 6854 C9 FF                 CMP   #$FF
0140 6856 D0 02                 BNE   test16
0141 6858 18                    CLC   
0142 6859 60                    RTS   
0143 685A              *
0144 685A A6 09        TEST16   LDX   mod~
0145 685C A4 F4                 LDY   RamBegAddr
0146 685E A5 0B        INV16    LDA   flip
0147 6860 CA                    DEX   
0148 6861 10 05                 BPL   jmp16
0149 6863 A2 02 00              LDX   #$02
0150 6866 A5 07                 LDA   thedata
0151 6868 D7 04        JMP16    CMP   [loc],y
0152 686A D0 1B                 BNE   Error16
0153 686C C8                    INY   
0154 686D C4 F2                 CPY   RamEndAddr
0155 686F 90 ED                 BCC   inv16
0156 6871 C6 09                 DEC   mod~
0157 6873 10 B7                 BPL   stepp16
0158 6875 A5 07                 LDA   thedata
0159 6877 49 FF                 EOR   #$ff
0160 6879 80 AA                 BRA   outer16
0161 687B              *
0162 687B              *
0163 687B 68           ERROR8   PLA                            ;Pull away a
0164 687C 57 04                 EOR   [loc],y
0165 687E E2 10                 SEP   #$10                     ;Index 8
0166 6880 A9 00                 LDA   #0
0167 6882 48                    PHA   
0168 6883 48                    PHA   
0169 6884 2B                    PLD   
0170 6885 80 02                 BRA   E2
0171 6887              ERROR16  EQU   *
0172 6887 57 04                 EOR   [loc],y
0173 6889 8D 17 03     E2       STA   ErrCode2
0174 688C A5 F0                 LDA   RamBank
0175 688E 8D 16 03              STA   ErrCode1
0176 6891 38                    SEC   
0177 6892 60                    RTS   
0178 6893              *
0179 6893              DOZPAGEIND EQU   *                      ;tests zero pages of any bank specified by RamBank
0180 6893 C2 10                 IND16 
0181 6895 A5 F0                 LDA   RamBank
0182 6897 F4 00 10              PEA   $1000                    ;Change Direct Page Register
0183 689A 2B                    PLD   
0184 689B 85 06                 STA   loc+2
0185 689D A0 00 00              LDY   #0
0186 68A0 84 04                 STY   loc                      ;was stx, but should be sty
0187 68A2 B7 04        ZPIND1   LDA   [loc],y
0188 68A4 48                    PHA   
0189 68A5 A9 FE                 LDA   #$fe
0190 68A7 A2 00 00              LDX   #$0000
0191 68AA 97 04        ZPIND2   STA   [loc],y
0192 68AC D7 04                 CMP   [loc],y
0193 68AE D0 CB                 BNE   Error8
0194 68B0 38                    SEC   
0195 68B1 2A                    ROL   a
0196 68B2 E8                    INX   
0197 68B3 E0 08 00              CPX   #$0008
0198 68B6 D0 F2                 BNE   ZPInd2
0199 68B8 CA                    DEX   
0200 68B9 A9 80                 LDA   #$80
0201 68BB 97 04        ZPIND4   STA   [loc],y
0202 68BD D7 04                 CMP   [loc],y
0203 68BF D0 BA                 BNE   Error8
0204 68C1 4A                    LSR   a
0205 68C2 CA                    DEX   
0206 68C3 10 F6                 BPL   ZPInd4
0207 68C5 68                    PLA   
0208 68C6 97 04                 STA   [loc],y
0209 68C8 C8                    INY   
0210 68C9 C0 00 04              CPY   #$0400
0211 68CC D0 D4                 BNE   ZPInd1
0212 68CE E2 10                 IND8 
0213 68D0 A9 00                 LDA   #0
0214 68D2 48                    PHA                            ;Reset Direct Page Register
0215 68D3 48                    PHA   
0216 68D4 2B                    PLD   
0217 68D5 18                    CLC   
0218 68D6 60                    RTS   
0219 68D7                       EJECT 
0220 68D7                       TITLE 'Serial Z8530 test.'
0221 68D7              ****************************************************************
0222 68D7              *
0223 68D7              *    File   :  SER.TST
0224 68D7              *
0225 68D7              *
0226 68D7              *   Serial tests for the SCC (8530)
0227 68D7              *
0228 68D7              *    14-Nov-85   :  JR    : New Today!
0229 68D7              *    23-Jan-86   :  JR    : Modified to run in ROM
0230 68D7              *
0231 68D7              *    See Diagnostics ERS for error codes
0232 68D7              *
0233 68D7              *    Data8, Data Bank = 0
0234 68D7              ****************************************************************
0235 68D7
0236 68D7              *
0237 68D7              *   Calls to the three test routines
0238 68D7              *
0239 68D7
0240 68D7              SER_TST  EQU   *
0241 68D7                                                      ; SEG	$00	;Should really be $FF, but program was written for bnk 0
0242 68D7 20 E0 68              JSR   SCCRegRW
0243 68DA B0 03                 BCS   SCCEnd
0244 68DC 20 5E 69              JSR   IntLoop
0245 68DF 6B           SCCEND   RTL                            ;
0246 68E0                       EJECT 
0247 68E0              ****************************************************************
0248 68E0              *
0249 68E0              *  SCC register R/W test
0250 68E0              *
0251 68E0              ****************************************************************
0252 68E0
0253 68E0              SCCREGRW EQU   *
0254 68E0
0255 68E0 78                    SEI                            ;isable interupts
0256 68E1 9C 0C 08              STZ   DATA
0257 68E4 9C 16 03              STZ   ErrCode1
0258 68E7 20 0F 6A              JSR   ResetSCC                 ;SCC reset & point to Chn A
0259 68EA A9 FF                 LDA   #$FF
0260 68EC 8D 0E 08              STA   SerMask                  ;BIT mask,for WR15 only
0261 68EF A9 02                 LDA   #2
0262 68F1 8D 0D 08              STA   RegNo                    ;Write register to test
0263 68F4 20 2A 69              JSR   RWChA                    ;Test Wr 2 for ChA only
0264 68F7 30 23                 BMI   FailRW
0265 68F9 A9 0C                 LDA   #12
0266 68FB 8D 0D 08              STA   RegNo                    ;Test Wr reg 12
0267 68FE 20 23 69              JSR   TstRW
0268 6901 30 19                 BMI   FailRW
0269 6903 EE 0D 08              INC   RegNo                    ;Test Wr reg 13
0270 6906 20 23 69              JSR   TstRW
0271 6909 30 11                 BMI   FailRW
0272 690B A9 FA                 LDA   #$FA
0273 690D 8D 0E 08              STA   SerMask                  ;Mask non R/W bits in Wr 15
0274 6910 A9 0F                 LDA   #15
0275 6912 8D 0D 08              STA   RegNo                    ;Test Wr reg 15
0276 6915 20 23 69              JSR   TstRW
0277 6918 30 02                 BMI   FailRW
0278 691A 18                    CLC   
0279 691B 60                    RTS   
0280 691C A9 01        FAILRW   LDA   #01
0281 691E 8D 16 03              STA   ErrCode1
0282 6921 38                    SEC   
0283 6922 60                    RTS   
0284 6923
0285 6923 A0 3B        TSTRW    LDY   #ChBIndex                ;Test Channel A & B
0286 6925 20 34 69              JSR   RegRW
0287 6928 30 09                 BMI   EndRWtst
0288 692A A0 3C        RWCHA    LDY   #ChAIndex
0289 692C 20 34 69              JSR   RegRW
0290 692F 30 02                 BMI   EndRWtst
0291 6931 A9 00        ZRTS     LDA   #0
0292 6933 60           ENDRWTST RTS                            ;
0293 6934
0294 6934 AD 0D 08     REGRW    LDA   RegNo                    ;Actual R/W test
0295 6937 99 FD BF              STA   SCCCmd,Y                 ;Point to the Wr reg
0296 693A AD 0C 08              LDA   DATA                     ;Initially = 0
0297 693D 2D 0E 08              AND   SerMask                  ;Mask out non R/W bits
0298 6940 8D 0F 08              STA   MaskData                 ;Store for later comparison
0299 6943 99 FD BF              STA   SCCCmd,Y                 ;Write the register
0300 6946 AD 0D 08              LDA   RegNo
0301 6949 99 FD BF              STA   SCCCmd,Y
0302 694C B9 FD BF              LDA   SCCCmd,Y                 ;Read the register
0303 694F CD 0F 08              CMP   MaskData                 ;Compare
0304 6952 D0 07                 BNE   BadData
0305 6954 CE 0C 08              DEC   DATA
0306 6957 D0 DB                 BNE   RegRW                    ;Try $0-FF
0307 6959 F0 D6                 BEQ   ZRTS
0308 695B A9 80        BADDATA  LDA   #$80
0309 695D 60                    RTS   
0310 695E                       EJECT 
0311 695E              ***************************************************************
0312 695E              *
0313 695E              *   Internal loopback test
0314 695E              *
0315 695E              ***************************************************************
0316 695E
0317 695E              INTLOOP  EQU   *
0318 695E
0319 695E 78                    SEI   
0320 695F 20 0F 6A              JSR   ResetSCC                 ;Reset SCC & point to Ch A
0321 6962 A0 3C                 LDY   #ChAIndex                ;
0322 6964 20 F8 69              JSR   SCCRegSet
0323 6967 20 7D 69              JSR   TstCh
0324 696A D0 0C                 BNE   IntLoopErr
0325 696C
0326 696C A0 3B                 LDY   #ChBIndex
0327 696E 20 F8 69              JSR   SCCRegSet
0328 6971 20 7D 69              JSR   TstCh
0329 6974 D0 02                 BNE   IntLoopErr
0330 6976 18                    CLC   
0331 6977 60                    RTS   
0332 6978
0333 6978 8D 16 03     INTLOOPERR STA   ErrCode1
0334 697B 38                    SEC   
0335 697C 60                    RTS   
0336 697D
0337 697D 9C 0C 08     TSTCH    STZ   DATA
0338 6980 9C 00 08     CHN1     STZ   CNT1
0339 6983 9C 01 08              STZ   CNT2
0340 6986 A9 00        TXCLR    LDA   #0
0341 6988 99 FD BF              STA   SCCCmd,Y
0342 698B B9 FD BF              LDA   SCCCmd,Y
0343 698E 29 04                 AND   #$04                     ;Tx Buffer empty status
0344 6990 D0 08                 BNE   SendData
0345 6992 CE 00 08              DEC   CNT1
0346 6995 D0 EF                 BNE   TxClr
0347 6997 A9 05                 LDA   #05                      ;Tx Buffer empty failure
0348 6999 60                    RTS   
0349 699A
0350 699A AD 0C 08     SENDDATA LDA   DATA
0351 699D 99 FF BF              STA   SCCData,Y
0352 69A0 9C 00 08              STZ   CNT1
0353 69A3 A9 01        ALLSENT  LDA   #1
0354 69A5 99 FD BF              STA   SCCCmd,y
0355 69A8 B9 FD BF              LDA   SCCCmd,Y
0356 69AB 29 01                 AND   #$01                     ;All Sent status
0357 69AD D0 0D                 BNE   ChkRead
0358 69AF CE 00 08              DEC   CNT1
0359 69B2 D0 EF                 BNE   AllSent
0360 69B4 CE 01 08              DEC   CNT2
0361 69B7 D0 EA                 BNE   ALLSENT
0362 69B9 A9 06                 LDA   #06                      ;All Sent status fail
0363 69BB 60                    RTS   
0364 69BC 9C 00 08     CHKREAD  STZ   CNT1
0365 69BF 9C 01 08              STZ   CNT2
0366 69C2 A9 00        CHKRD    LDA   #0
0367 69C4 99 FD BF              STA   SCCCmd,Y
0368 69C7 B9 FD BF              LDA   SCCCmd,Y
0369 69CA 29 01                 AND   #$01                     ;Rx charecter available
0370 69CC D0 08                 BNE   ChkData
0371 69CE CE 00 08              DEC   CNT1
0372 69D1 D0 EF                 BNE   ChkRd
0373 69D3 A9 07                 LDA   #07                      ;Rx char available error
0374 69D5 60                    RTS   
0375 69D6 B9 FF BF     CHKDATA  LDA   SCCData,Y
0376 69D9 CD 0C 08              CMP   DATA
0377 69DC F0 03                 BEQ   TxChk
0378 69DE A9 08                 LDA   #08                      ;Bad Data
0379 69E0 60                    RTS   
0380 69E1
0381 69E1 A9 01        TXCHK    LDA   #1
0382 69E3 99 FD BF              STA   SCCCmd,Y
0383 69E6 B9 FD BF              LDA   SCCCmd,Y
0384 69E9 29 70                 AND   #$70                     ;Framing, Overrun & Parity errors
0385 69EB F0 03                 BEQ   AGAIN
0386 69ED A9 09                 LDA   #09                      ;Frame, Overrun or Parirty error
0387 69EF 60                    RTS   
0388 69F0
0389 69F0 CE 0C 08     AGAIN    DEC   DATA
0390 69F3              * BEQ Retrn 
0391 69F3              * BRA Chn1
0392 69F3
0393 69F3 D0 8B                 BNE   CHN1
0394 69F5
0395 69F5 A9 00        RETRN    LDA   #0
0396 69F7 60                    RTS   
0397 69F8
0398 69F8 A2 00        SCCREGSET LDX   #0
0399 69FA BF 1C 6A FF  SETENV2  LDA   >TBL2,X                  ;Set up the SCC registers
0400 69FE 99 FD BF              STA   SCCCmd,Y                 ;  for internal loopback.
0401 6A01 E8                    INX   
0402 6A02 BF 1C 6A FF           LDA   >TBL2,X
0403 6A06 99 FD BF              STA   SCCCmd,Y
0404 6A09 E8                    INX   
0405 6A0A E0 10                 CPX   #16
0406 6A0C D0 EC                 BNE   SetEnv2
0407 6A0E 60                    RTS   
0408 6A0F
0409 6A0F              *
0410 6A0F              *   Reset the SCC
0411 6A0F              *
0412 6A0F
0413 6A0F A0 3C        RESETSCC LDY   #ChAIndex                ;Channel A
0414 6A11 A9 09                 LDA   #$9                      ;Reg 9
0415 6A13 99 FD BF              STA   SCCCmd,Y
0416 6A16 A9 C0                 LDA   #$C0                     ;Force an SCC reset
0417 6A18 99 FD BF              STA   SCCCmd,Y
0418 6A1B 60                    RTS   
0419 6A1C
0420 6A1C                                                      ; SEG	RUNBANK	;Normally bank $FF
0421 6A1C              TBL2     EQU   *
0422 6A1C 09 00                 DC B:9,$00                     ;Disable interupts
0423 6A1E 04 4C                 DC B:4,$4C                     ;X16 clk 2 Stp bits
0424 6A20 0B D0                 DC B:11,$D0                    ;Xtal RTxC
0425 6A22 0C 5E                 DC B:12,$5E                    ;Low Byte Time const
0426 6A24 0D 00                 DC B:13,$00                    ;Hi Byte Time const
0427 6A26 0E 13                 DC B:14,$13                    ;Loopback BR enable
0428 6A28 03 C1                 DC B:3,$C1                     ;Rx 8bits
0429 6A2A 05 6A                 DC B:5,$6A                     ;Tx 8bits Tx enable RTS
0430 6A2C
0431 6A2C                       TITLE 'Cortland softswitch test'
0432 6A2C              ***********************************************************
0433 6A2C              *
0434 6A2C              * MAIN PROG TO test cortland softswitches
0435 6A2C              * 8 BIT ROUTINE
0436 6A2C              * Enter with Data Bank = $00
0437 6A2C              * Returns with RTL and in 8 bit EML mode.
0438 6A2C              *
0439 6A2C              * Test returns with carry set if fail, else carry clear
0440 6A2C              * kg 01 OCT 85: Created
0441 6A2C              * KG 03 JAN 86: Modified to run in Bank $FF rom
0442 6A2C              *
0443 6A2C              *
0444 6A2C              * Karl Grabe. Apple Computer Inc., Corcaig
0445 6A2C              ***********************************************************
0446 6A2C              *
0447 6A2C              * Now test each softswitch by setting & checking if set,
0448 6A2C              * then clearing and checking if clear.
0449 6A2C              *
0450 6A2C              * 8 of the softswitches have equivalent bits in the STATEREG
0451 6A2C              * register and these are tested/set/reset and verified
0452 6A2C              * for correct value and function.
0453 6A2C              *
0454 6A2C              * If a fail occurs then:
0455 6A2C              *       1.   The carry flag is set
0456 6A2C              *       2.   A contains the failed STATEREG bit ( if any )
0457 6A2C              *       3.   TST.STATUS+2 +$C000 gives the read softswitch location
0458 6A2C              *            that the fail occurred on
0459 6A2C              *       4.   TST.STATUS+1 contains STATEREG bit in error
0460 6A2C              *
0461 6A2C              * NOTE: Call in NTV DATA8, Data Bank =$00
0462 6A2C              *
0463 6A2C              *
0464 6A2C              ***********************************************************
0465 6A2C
0466 6A2C              SOFT_SW  EQU   *
0467 6A2C                                                      ; SEG	RUNBANK
0468 6A2C 4B                    PHK   
0469 6A2D AB                    PLB   
0470 6A2E A9 01                 LDA   #$01                     ;STATEREG bit mask
0471 6A30 A0 29                 LDY   #SOFT_TAB_SIZE           ;For all softswitches
0472 6A32 BE 9C 6A     NEXT_SW  LDX   SOFT_TAB+1,Y             ;Get ready to set switch
0473 6A35 E0 FF                 CPX   #NOT_SW                  ;Test for skip or not
0474 6A37 F0 4A                 BEQ   INC_SW_1                 ;Skip this soft switch
0475 6A39
0476 6A39              * Set switch ...
0477 6A39 9F 00 C0 00           STA   >IOADR,X                 ;Set it now
0478 6A3D BE 9D 6A              LDX   SOFT_TAB+2,Y             ;Get ready to read the switch
0479 6A40 20 FB 66              JSR   BANK_0                   ;Set data bank reg to zero
0480 6A43 1E 00 C0              ASL   |IOADR,X                 ;Put bit 7 into carry
0481 6A46 90 47                 BCC   MEGA_SOFT_ER             ;Mega softswitch error
0482 6A48
0483 6A48              * STATEREG ...
0484 6A48 C9 00                 CMP   #$00                     ;More STATEREG bits to test ?
0485 6A4A F0 20                 BEQ   CLR_SW                   ;No ... skip STATEREG test
0486 6A4C 89 0C                 BIT   #%00001100               ;Testing bit 2 ?
0487 6A4E D0 19                 BNE   STATE_INV                ;Yes ... so test inverted.
0488 6A50 20 FB 66              JSR   BANK_0                   ;Set data bank reg to zero
0489 6A53 1C 68 C0              TRB   |STATEREG                ;Test/reset using A mask
0490 6A56 F0 37                 BEQ   MEGA_SOFT_ER             ;State reg does'nt match
0491 6A58 1E 00 C0              ASL   |IOADR,X                 ;Does STATEREG clr softsw?
0492 6A5B B0 32                 BCS   MEGA_SOFT_ER             ;No so err
0493 6A5D 0C 68 C0              TSB   |STATEREG                ;Test/set using A mask
0494 6A60 D0 2D                 BNE   MEGA_SOFT_ER             ;STATEREG did not set, err
0495 6A62 1E 00 C0              ASL   |IOADR,X                 ;Does STATEREG set softssw ?
0496 6A65 90 28                 BCC   MEGA_SOFT_ER             ;No .. er
0497 6A67 80 03                 BRA   CLR_SW                   ;Jump over inverted bits test
0498 6A69
0499 6A69              STATE_INV EQU   *                       ;Not branched to on new production Mega //
0500 6A69 0C 68 C0              TSB   |STATEREG                ;Test/reset using A mask
0501 6A6C
0502 6A6C              * Clear switch ...
0503 6A6C              CLR_SW   EQU   *
0504 6A6C 4B                    PHK   
0505 6A6D AB                    PLB   
0506 6A6E BE 9B 6A              LDX   SOFT_TAB,Y               ;Get ready to clear
0507 6A71 9F 00 C0 00           STA   >IOADR,X                 ;Clear it
0508 6A75 BE 9D 6A              LDX   SOFT_TAB+2,Y             ;Get ready to read softswitch
0509 6A78 20 FB 66              JSR   BANK_0                   ;Set data bank reg to zero
0510 6A7B 1E 00 C0              ASL   |IOADR,X                 ;Put bit 7 into carry
0511 6A7E B0 0F                 BCS   MEGA_SOFT_ER             ;Mega softswitch error
0512 6A80 4B                    PHK   
0513 6A81 AB                    PLB   
0514 6A82 88           INC_SW   DEY                            ;softsw cntr by 3
0515 6A83 88           INC_SW_1 DEY                            ;softsw cntr by 2
0516 6A84 0A                    ASL   A                        ;Move to next STATEREG bit
0517 6A85 88                    DEY   
0518 6A86 10 AA                 BPL   NEXT_SW                  ;Do next soft switch
0519 6A88
0520 6A88 A9 0C        NORMSTATE LDA   #$0C
0521 6A8A 8D 68 C0              STA   |STATEREG                ;Restore to 'normal' settings
0522 6A8D 18           NORMRTL  CLC                            ;r carry for test pass
0523 6A8E 6B                    RTL   
0524 6A8F
0525 6A8F              MEGA_SOFT_ER EQU   *
0526 6A8F 8D 16 03              STA   |TST_STATUS+1            ;State register Bit at fault (if any)
0527 6A92 8E 17 03              STX   |TST_STATUS+2            ;>of soft switch at fault
0528 6A95 22 88 6A FF           JSL   >NORMSTATE
0529 6A99 38                    SEC                            ;carry as test fails
0530 6A9A 6B                    RTL                            ;rmine faulty softwsitch from Y
0531 6A9B                       EJECT 
0532 6A9B              ***********************************************************
0533 6A9B              *
0534 6A9B              * Softswitches table:
0535 6A9B              * Format: Clear softswitch, Set softswitch, Read softswitch
0536 6A9B              * The last 8 softswitches have a STATEREG bit.
0537 6A9B              *
0538 6A9B              ***********************************************************
0539 6A9B
0540 6A9B              SOFT_TAB EQU   *
0541 6A9B 0A 0B 17              DC B:SETINTC3ROM,SETSLOTC3ROM,RDC3ROM
0542 6A9E 00 01 18              DC B:CLR80COL,SET80COL,RD80COL
0543 6AA1 50 51 1A              DC B:TXTCLR,TXTSET,RDTEXT
0544 6AA4 52 53 1B              DC B:MIXCLR,MIXSET,RDMIX
0545 6AA7 56 57 1D              DC B:LORES,HIRES,RDHIRES
0546 6AAA 0E 0F 1E              DC B:CLRALTCHAR,SETALTCHAR,ALTCHARSET
0547 6AAD 0C 0D 1F              DC B:CLR80VID,SET80VID,RD80VID
0548 6AB0              *
0549 6AB0              * The following softswitches have an equivalent bit
0550 6AB0              * in the Mega // STATEREG register.
0551 6AB0              *
0552 6AB0 08 09 16     STATE_7  DC B:SETSTDZP,SETALTZP,RDALTZP ;Bit 7
0553 6AB3 54 55 1C     STATE_6  DC B:TXTPAGE1,TXTPAGE2,RDPAGE2 ;Bit 6
0554 6AB6 02 03 13     STATE_5  DC B:RDMAINRAM,RDCARDRAM,RDRAMRD ;Bit 5
0555 6AB9 04 05 14     STATE_4  DC B:WRMAINRAM,WRCARDRAM,RDRAMWRT ;Bit 4
0556 6ABC 8B 83 11     STATE_3  DC B:LCBANK1,LCBANK2,RDLCBNK2  ;Bit 3
0557 6ABF 81 8B 12     STATE_2  DC B:ROMIN,LCBANK1,RDLCRAM     ;Bit 2
0558 6AC2 FF 28        STATE_1  DC B:NOT_SW,ROMBANK            	;Not soft switch. Bit 1 STATEREG
0559 6AC4 06 07 15     STATE_0  DC B:SETSLOTCXROM,SETINTCXROM,RDCXROM ;Bit 0 STATEREG
0560 6AC7              SOFT_TAB_SIZE EQU   *-SOFT_TAB-3
0561 6AC7              SOFT_END EQU   *
0562 6AC7                                                      ; SEG	$00
0563 6AC7                       TITLE 'FPI/MEGA SPEED TEST'
0564 6AC7              ;...............................................................
0565 6AC7              ; FPI.SPEED
0566 6AC7              ;
0567 6AC7              ;
0568 6AC7              ; MAIN PROG TO CHECK FAST/SLOW SPEED RATIO OF RAMBO
0569 6AC7              ;
0570 6AC7              ; K.G. 17 SEP 85
0571 6AC7              ;
0572 6AC7              ; 17 SEP 85  File Created
0573 6AC7              ; 14 FEB 86  Modified to run in Bank $FF rom
0574 6AC7              ;
0575 6AC7              ; Call in Native mode 8, Data Bank = $00
0576 6AC7              ; Returns with RTL in Native Mode, Data8, Data Bank = $00
0577 6AC7              ;
0578 6AC7              ;  Errors: TST.STATUS+1: 1=>stuck fast, 2=>stuck slow
0579 6AC7              ;          TST.STATUS+2: Bad ratio measured
0580 6AC7              ;
0581 6AC7              ; By Karl Grabe  Apple Computer Ltd. Cork
0582 6AC7              ;...............................................................
0583 6AC7
0584 6AC7              FPI_SPEED EQU   *                       ;Sequencer calls with JSL 
0585 6AC7                                                      ; SEG	RUNBANK	;Bank code is running in
0586 6AC7              LBL00    EQU   *                        ;Check correct Video counter freq in Fast mode
0587 6AC7 A9 80                 LDA   #%10000000               ; SET FPI FAST
0588 6AC9 8D 36 C0              STA   |CYAREG
0589 6ACC 20 F1 6A              JSR   FIND_SPEED               ;Leave result in X
0590 6ACF A0 01                 LDY   #1                       ;Section of the test if it fails =1
0591 6AD1 E0 19                 CPX   #>FAST_LIM               ;Test low value first
0592 6AD3 F0 04                 BEQ   NOW_SLOW                 ;Is good so check slow mode
0593 6AD5 E0 1A                 CPX   #<FAST_LIM               ;Try high value
0594 6AD7 D0 10                 BNE   BAD_SPEED                ;Bad so error
0595 6AD9
0596 6AD9              NOW_SLOW EQU   *                        ;Check correct Video counter freq in Slow mode
0597 6AD9 9C 36 C0              STZ   |CYAREG                  ;slow mode
0598 6ADC 20 F1 6A              JSR   FIND_SPEED
0599 6ADF A0 02                 LDY   #2                       ;Section of the test if it fails =2
0600 6AE1 E0 0C                 CPX   #>SLOW_LIM               ;Test low value
0601 6AE3 F0 A8                 BEQ   NORMRTL
0602 6AE5 E0 0D                 CPX   #<SLOW_LIM               ;Try high value
0603 6AE7 F0 A4                 BEQ   NORMRTL
0604 6AE9
0605 6AE9              BAD_SPEED EQU   *                       ;Failed speed test if here
0606 6AE9 8C 16 03              STY   |TST_STATUS+1            ;Section of test that failed (1..2)
0607 6AEC 8E 17 03              STX   |TST_STATUS+2            ;Wrong value we found
0608 6AEF 38                    SEC                            ;d status
0609 6AF0 6B                    RTL   
0610 6AF1                       EJECT 
0611 6AF1              ****************************************************************
0612 6AF1              *
0613 6AF1              * Find speed of 816 relative to the Vertical video counter
0614 6AF1              * The X register ends up with a no which is proportional
0615 6AF1              * to the speed of the 816 with respect to the Vertical video
0616 6AF1              * counter which is running at a constant rate.
0617 6AF1              *
0618 6AF1              * Call/Ret in NTV8 mode
0619 6AF1              *
0620 6AF1              * Return with speed relative speed in X register.
0621 6AF1              *
0622 6AF1              *
0623 6AF1              * Note that this test also takes into account the
0624 6AF1              * fact that the FPI should slow down when accessing
0625 6AF1              * the Mega // video counters.
0626 6AF1              *
0627 6AF1              ****************************************************************
0628 6AF1
0629 6AF1 A2 00        FIND_SPEED LDX   #0                     ;Zero counter.
0630 6AF3 AF 2E C0 00           LDA   >VERTCNT                 ;Get vertical video counter
0631 6AF7 CF 2E C0 00  LBL01    CMP   >VERTCNT                 ;Wait till it changes
0632 6AFB F0 FA                 BEQ   LBL01                    ;Loop till new line
0633 6AFD AF 2E C0 00           LDA   >VERTCNT                 ;Just begun new value so get it
0634 6B01 E8           LBL02    INX                            ;counts occurences of same VERTCNT
0635 6B02 CF 2E C0 00           CMP   >VERTCNT
0636 6B06 F0 F9                 BEQ   LBL02                    ;Repeate till it changes again
0637 6B08 60                    RTS   
0638 6B09                       TITLE 'MEGA // Int test.'
0639 6B09              ****************************************************************
0640 6B09              *
0641 6B09              *    File : Custom.IRQ
0642 6B09              *
0643 6B09              ****************************************************************
0644 6B09              *
0645 6B09              *   MEGA and VGC interupts test.
0646 6B09              *
0647 6B09              *  Modification history:
0648 6B09              *
0649 6B09              *  12th-Nov-85   :  JR   : Created
0650 6B09              *  17th-Feb-86   :  JR   : Modified for Rom
0651 6B09              *
0652 6B09              * Sequencer calls in NTV8 mode, Data Bank = $00 with JSL.
0653 6B09              *
0654 6B09              ****************************************************************
0655 6B09
0656 6B09                                                      ; SEG	$00	;Code was written for bank $00
0657 6B09
0658 6B09              CUSTOM_IRQ EQU   *                      ;Sequencer entry point 
0659 6B09 20 12 6B              JSR   MEGATstIRQ               ;Test Mega // interupts
0660 6B0C B0 03                 BCS   CUS_IRQ_RTL              ;Found error so RTL
0661 6B0E 20 CA 6B              JSR   VGCTstIRQ                ;Now VGC
0662 6B11 6B           CUS_IRQ_RTL RTL                         ;
0663 6B12
0664 6B12              *
0665 6B12              *   VBL interupt
0666 6B12              *
0667 6B12
0668 6B12              MEGATSTIRQ EQU   *
0669 6B12 78                    SEI   
0670 6B13 AF 11 00 E1           LDA   >INTMGRV+1
0671 6B17 8D 0C 70              STA   IRQTEMP3
0672 6B1A AF 12 00 E1           LDA   >INTMGRV+2
0673 6B1E 8D 08 70              STA   IRQTemp1
0674 6B21 AF 13 00 E1           LDA   >INTMGRV+3
0675 6B25 8D 0A 70              STA   IRQTemp2
0676 6B28 A9 BD                 LDA   #<MEGAIntHnd
0677 6B2A 8F 11 00 E1           STA   >INTMGRV+1
0678 6B2E A9 6B                 LDA   #>MEGAIntHnd
0679 6B30 8F 12 00 E1           STA   >INTMGRV+2
0680 6B34 A9 FF                 LDA   #^MEGAIntHnd
0681 6B36 8F 13 00 E1           STA   >INTMGRV+3
0682 6B3A
0683 6B3A 9C 41 C0              STZ   INTEN
0684 6B3D 9C 00 08              STZ   CNT1
0685 6B40 9C 01 08              STZ   CNT2
0686 6B43 9C 00 70              STZ   CusIRQCnt
0687 6B46 58                    CLI   
0688 6B47
0689 6B47 9C 47 C0              STZ   CLRVBLINT
0690 6B4A A9 08                 LDA   #%00001000
0691 6B4C 8D 41 C0              STA   INTEN
0692 6B4F AD 00 70     LOOP001  LDA   CusIRQCnt
0693 6B52 C9 01                 CMP   #1
0694 6B54 F0 0E                 BEQ   VBLIRQTst
0695 6B56 CE 00 08              DEC   CNT1                     ;
0696 6B59 D0 F4                 BNE   loop001                  ;
0697 6B5B CE 01 08              DEC   cnt2                     ;
0698 6B5E D0 EF                 BNE   Loop001
0699 6B60 A9 01                 LDA   #$01
0700 6B62 80 37                 BRA   MegaErr
0701 6B64
0702 6B64 AD 02 70     VBLIRQTST LDA   CusIRQsts
0703 6B67 29 08                 AND   #%00001000
0704 6B69 D0 04                 BNE   QtrIRQ
0705 6B6B A9 02                 LDA   #$02
0706 6B6D 80 2C                 BRA   MegaErr
0707 6B6F
0708 6B6F              *
0709 6B6F              *  1/4 secound interupt
0710 6B6F              *
0711 6B6F
0712 6B6F 9C 00 08     QTRIRQ   STZ   CNT1
0713 6B72 9C 01 08              STZ   CNT2
0714 6B75 9C 47 C0              STZ   CLRVBLINT
0715 6B78 A9 10                 LDA   #%00010000
0716 6B7A 8D 41 C0              STA   INTEN
0717 6B7D AD 00 70     LOOP002  LDA   CusIRQCNT
0718 6B80 C9 02                 CMP   #2
0719 6B82 F0 0E                 BEQ   TstQtrIRQ
0720 6B84 CE 00 08              DEC   cnt1                     ;
0721 6B87 D0 F4                 BNE   loop002                  ;
0722 6B89 CE 01 08              DEC   cnt2                     ;
0723 6B8C D0 EF                 BNE   Loop002
0724 6B8E A9 03                 LDA   #$03
0725 6B90 80 09                 BRA   MegaErr
0726 6B92
0727 6B92 AD 02 70     TSTQTRIRQ LDA   CusIRQsts
0728 6B95 29 10                 AND   #%00010000
0729 6B97 D0 05                 BNE   MegRstre
0730 6B99 A9 04                 LDA   #$04
0731 6B9B
0732 6B9B 8D 16 03     MEGAERR  STA   ErrCode1
0733 6B9E
0734 6B9E              MEGRSTRE EQU   *                        ;
0735 6B9E 78                    SEI                            ; turn off interrupts
0736 6B9F AD 0C 70              LDA   IRQTEMP3
0737 6BA2 8F 11 00 E1           STA   >INTMGRV+1
0738 6BA6 AD 08 70              LDA   IRQTemp1
0739 6BA9 8F 12 00 E1           STA   >INTMGRV+2
0740 6BAD AD 0A 70              LDA   IRQTemp2
0741 6BB0 8F 13 00 E1           STA   >INTMGRV+3
0742 6BB4 AD 16 03              LDA   ErrCode1
0743 6BB7 F0 02                 BEQ   MegaPass
0744 6BB9 38                    SEC   
0745 6BBA 60                    RTS   
0746 6BBB 18           MEGAPASS CLC                            ;
0747 6BBC 60                    RTS   
0748 6BBD
0749 6BBD                                                      ; SEG	RUNBANK	;Rom code bank
0750 6BBD              MEGAINTHND EQU   *
0751 6BBD 9C 41 C0              STZ   |INTEN
0752 6BC0 AD 46 C0              LDA   |INTFLAG
0753 6BC3 8D 02 70              STA   |CusIRQsts
0754 6BC6 EE 00 70              INC   |CusIRQCnt
0755 6BC9 40                    RTI   
0756 6BCA                                                      ; SEG	$00
0757 6BCA                       TITLE 'VGC IRQ Test.'
0758 6BCA              ;*****************************************************************
0759 6BCA              *
0760 6BCA              *   This is a test of the VGC 1 sec interrupt , and of each of
0761 6BCA              *   the possable scan line interupts .
0762 6BCA              *
0763 6BCA              *     13.Nov.85
0764 6BCA              *
0765 6BCA              ;*****************************************************************
0766 6BCA
0767 6BCA              VGCTSTIRQ EQU   *
0768 6BCA E2 30                 DATA8 
0769 6BCC 78                    SEI   
0770 6BCD AF 11 00 E1           LDA   >INTMGRV+1
0771 6BD1 8D 0C 70              STA   IRQTEMP3
0772 6BD4 AF 12 00 E1           LDA   >INTMGRV+2
0773 6BD8 8D 08 70              STA   IRQTemp1
0774 6BDB AF 13 00 E1           LDA   >INTMGRV+3
0775 6BDF 8D 0A 70              STA   IRQTemp2
0776 6BE2 A9 5D                 LDA   #<VGCIntHnd
0777 6BE4 8F 11 00 E1           STA   >INTMGRV+1
0778 6BE8 A9 6C                 LDA   #>VGCIntHnd
0779 6BEA 8F 12 00 E1           STA   >INTMGRV+2
0780 6BEE A9 FF                 LDA   #^VGCIntHnd
0781 6BF0 8F 13 00 E1           STA   >INTMGRV+3
0782 6BF4
0783 6BF4 9C 23 C0              STZ   VGCINT                   ;VGC Interupts off
0784 6BF7 9C 32 C0              STZ   SCANINT                  ;Clear IRQ flags
0785 6BFA 9C 06 70              STZ   CusIRQSrce               ;Point to 1 sec 
0786 6BFD 9C 00 70              STZ   CusIRQCnt
0787 6C00 9C 01 08              STZ   CNT2
0788 6C03 A9 10                 LDA   #$10                     ;About  4 seconds
0789 6C05 8D 02 08              STA   CNT3                     ;Timeout limit for 1 sec IRQ
0790 6C08
0791 6C08 58                    CLI   
0792 6C09 A9 04                 LDA   #%00000100
0793 6C0B 8D 23 C0              STA   VGCINT
0794 6C0E AD 00 70     LOOP003  LDA   CusIRQCNT
0795 6C11 C9 01                 CMP   #1
0796 6C13 F0 13                 BEQ   TstSecIRQ
0797 6C15 CE 00 08              DEC   cnt1                     ;
0798 6C18 D0 F4                 BNE   loop003                  ;
0799 6C1A CE 01 08              DEC   cnt2                     ;
0800 6C1D D0 EF                 BNE   Loop003
0801 6C1F CE 02 08              DEC   CNT3
0802 6C22 D0 EA                 BNE   Loop003
0803 6C24 A9 05                 LDA   #$05
0804 6C26 80 0B                 BRA   ERROR2
0805 6C28                       EJECT 
0806 6C28              TSTSECIRQ EQU   *
0807 6C28 AD 02 70              LDA   CusIRQsts                ;Test the IRQ flag
0808 6C2B 29 C4                 AND   #$C4                     ;Test bits 2,6,7 only!!!!!!!
0809 6C2D C9 C4                 CMP   #$C4                     ;For New VGC's  - 31 MAR 86
0810 6C2F                       IF VGC_SWITCH <> 0 THEN        ;For VGC's after about 31 Mar
0811 6C2F F0 05                 BEQ   ScanTst                  ;Scan Line interrupt
0812 6C31                       ELSE 
0813 6C31                       BEQ   VGCRstre                 ;( BEQ ScanTst for production VGC's)
0814 6C31                       ENDIF 
0815 6C31 A9 06                 LDA   #$06
0816 6C33 8D 16 03     ERROR2   STA   ErrCode1
0817 6C36
0818 6C36 78           VGCRSTRE SEI                            ;
0819 6C37 9C 23 C0              STZ   VGCINT
0820 6C3A A9 01                 LDA   #$01
0821 6C3C 8D 29 C0              STA   NEWVIDEO
0822 6C3F AD 0C 70              LDA   IRQTEMP3
0823 6C42 8F 11 00 E1           STA   >INTMGRV+1
0824 6C46 AD 08 70              LDA   IRQTemp1
0825 6C49 8F 12 00 E1           STA   >INTMGRV+2
0826 6C4D AD 0A 70              LDA   IRQTemp2
0827 6C50 8F 13 00 E1           STA   >INTMGRV+3
0828 6C54 AD 16 03              LDA   ErrCode1
0829 6C57 F0 02                 BEQ   VGCPass
0830 6C59 38                    SEC   
0831 6C5A 60                    RTS   
0832 6C5B 18           VGCPASS  CLC                            ;
0833 6C5C 60                    RTS   
0834 6C5D
0835 6C5D              *
0836 6C5D              *  Scan line test
0837 6C5D              *
0838 6C5D
0839 6C5D                       IF VGC_SWITCH <> 0 THEN        ;For new VGC's/room in rom
0840 6C5D              SCANTST  SEI                            ;
0841 6C5D AD 23 C0              LDA   #$FF
0842 6C60 8D 02 70              STA   CusIRQCnt
0843 6C63                       STA   CusIRQSrce
0844 6C63                       STZ   CusLineNo
0845 6C63                       STZ   VGCINT
0846 6C63                       STZ   SCANINT
0847 6C63                       STZ   CNT1
0848 6C63                       STZ   CNT2
0849 6C63 AD 06 70              LDA   #$C1
0850 6C66                       STA   NEWVIDEO                 ;Enable hires
0851 6C66              SCNLINE  LDX   CusLineNo                ;One line at a time
0852 6C66              SETIRQ   LDA   #%01000000
0853 6C66                       ORA   $019D00,X
0854 6C66                       STA   $019D00,X                ;Set the IRQ bit
0855 6C66                       CLI   
0856 6C66                       LDA   #%00000010
0857 6C66                       STA   VGCINT
0858 6C66              WAITFIN  LDA   CusIRQCnt
0859 6C66                       CMP   CusLineNo
0860 6C66 F0 0D                 BEQ   ScnIRQTst
0861 6C68                       DEC   CNT1
0862 6C68                       BNE   WaitFIN
0863 6C68                       DEC   CNT2
0864 6C68                       BNE   WaitFIN
0865 6C68                       LDA   #$07
0866 6C68                       BRA   ERROR2
0867 6C68
0868 6C68
0869 6C68              SCNIRQTST LDA   CusIRQsts
0870 6C68                       CMP   #$B2
0871 6C68                       BNE   FailSts
0872 6C68                       INC   CusLineNo
0873 6C68                       LDA   CusLineNo
0874 6C68                       CMP   #0                       ;Wrap a round
0875 6C68                       BNE   ScnLine
0876 6C68                       BRA   VGCRstre
0877 6C68              FAILSTS  LDA   #$08
0878 6C68                       BRL   ERROR2
0879 6C68                       ENDIF 
0880 6C68
0881 6C68                                                      ; SEG	RUNBANK
0882 6C68              VGCINTHND EQU   *                       ;VGC interupt handler
0883 6C68                                                      ; SEG	$00
0884 6C68                       LDA   VGCINT
0885 6C68                       STA   CusIRQsts
0886 6C68                       LDA   CusIRQSrce
0887 6C68                       BEQ   IncCnt
0888 6C68 AE 04 70              LDX   CusLineNo
0889 6C6B A9 BF                 LDA   #%10111111
0890 6C6D 3F 00 9D 01           AND   $019D00,X
0891 6C71 9F 00 9D 01           STA   $019D00,X
0892 6C75 9C 23 C0     INCCNT   STZ   VGCINT
0893 6C78 EE 00 70              INC   CusIRQCnt
0894 6C7B 40                    RTI   
0895 6C7C                       EJECT 
0896 6C7C                       TITLE 'Vegas ROM test'
0897 6C7C              ;...............................................................
0898 6C7C              ; ROM.CHECKSUM
0899 6C7C              ;
0900 6C7C              ; Compute Checksum of rom banks $FE, $FF.
0901 6C7C              ; and compare with expected value
0902 6C7C              ;
0903 6C7C              ; Call  :   In Full native mode, Data Bank 0, use JSL
0904 6C7C              ; Return:   In Full native mode
0905 6C7C              ;
0906 6C7C              ; 20 Feb 86: Created
0907 6C7C              ; 09 Apr 86: Add register based ram test
0908 6C7C              ;
0909 6C7C              ; By Karl Grabe, Apple Computer INC., Cork
0910 6C7C              ;...............................................................
0911 6C7C
0912 6C7C                                                      ; SEG	RUNBANK
0913 6C7C              ROM_CHECKSUM EQU   *                    ;Called from  test sequencer
0914 6C7C 64 F0                 STZ   RamBank
0915 6C7E 20 93 68              JSR   DoZPageInd               ;Register based ram test first
0916 6C81 C2 30                 DATA16 
0917 6C83 B0 3C                 BCS   BAD_RAM                  ;Ram is bad so report and stop
0918 6C85 64 FD                 STZ   CHK_BEG                  ;Starting address
0919 6C87 F4 FC FC              PEA   |$FCFC                   ;Firts bank $FC
0920 6C8A AB                    PLB   
0921 6C8B AB                    PLB                            ;et data bank register
0922 6C8C A0 FF FF              LDY   #$FFFF                   ;Entire 64k of rom
0923 6C8F 20 CC 6C              JSR   CAL_CHECKSUM             ;Go get checksum
0924 6C92 F4 FD FD              PEA   |$FDFD                   ;Bank $FD
0925 6C95 AB                    PLB   
0926 6C96 AB                    PLB   
0927 6C97 88                    DEY                            ;Entire 64k of rom
0928 6C98 20 D0 6C              JSR   CAL_CHECKSUM2            ;Get checksum
0929 6C9B F4 FE FE              PEA   |$FEFE                   ;Bank $FE
0930 6C9E AB                    PLB   
0931 6C9F AB                    PLB   
0932 6CA0 88                    DEY                            ;Entire 64k of rom
0933 6CA1 20 D0 6C              JSR   CAL_CHECKSUM2            ;Get checksum
0934 6CA4 F4 FF FF              PEA   |$FFFF                   ;Bank $FF
0935 6CA7 AB                    PLB   
0936 6CA8 AB                    PLB   
0937 6CA9 88                    DEY                            ;Entire 64k of rom
0938 6CAA 20 D0 6C              JSR   CAL_CHECKSUM2            ;Get checksum
0939 6CAD              ;
0940 6CAD              ; Note that the rom checksum must be adjusted 
0941 6CAD              ; to equal $1234
0942 6CAD              ;
0943 6CAD C9 34 12              CMP   #$1234                   ;Compare with a fixed value
0944 6CB0              ; Change CHECKSUM condition in file: MAIN
0945 6CB0                       IF CHECKSUM <> 0 THEN          ;Normally do next line
0946 6CB0 D0 02                 BNE   BAD_ROM                  ;Bad checksum so fail
0947 6CB2                       ELSE                           ;Do next line for debugging only
0948 6CB2                       BRA   GOOD_ROM                 ;Don't fail ROM checkum
0949 6CB2                       ENDIF 
0950 6CB2              GOOD_ROM EQU   *                        ;Rom ok
0951 6CB2 18                    CLC   
0952 6CB3 6B                    RTL   
0953 6CB4              BAD_ROM  EQU   *                        ;Rom does'nt check out
0954 6CB4 8F 16 03 00           STA   >TST_STATUS+1            ;Save actual checksum for display
0955 6CB8 A9 D2 CD              LDA   #$CDD2                   ;"RM" = RoM fail
0956 6CBB 8F 00 05 00           STA   >LINE1+$100              ;Put "RM" msg on screen in case system hangs
0957 6CBF 38                    SEC   
0958 6CC0 6B                    RTL                            ;ttempt to return to sequencer to put bad message on screen
0959 6CC1              BAD_RAM  EQU   *                        ;Encountered bad ram during rom test
0960 6CC1 A9 01 00              LDA   #$01                     ;Bad ram
0961 6CC4 8D 18 03              STA   |TST_STATUS+3            ;01-> can't do rom tst because bad ram
0962 6CC7 8D 16 03              STA   |TST_STATUS+1            ;Error that occurred (See Test code)
0963 6CCA 38                    SEC   
0964 6CCB 6B                    RTL   
0965 6CCC                       EJECT 
0966 6CCC              ;...............................................................
0967 6CCC              ;
0968 6CCC              ; Calculate Checksum. 16 Bit ADC
0969 6CCC              ;
0970 6CCC              ; Call  :   In Full native mode, use JSR
0971 6CCC              ; Return:   In Full native mode
0972 6CCC              ;
0973 6CCC              ; Inputs:
0974 6CCC              ;        C: Partially computed checksum, or else 0
0975 6CCC              ;  CHK.BEG: Start address to checksum (Zero Page var)
0976 6CCC              ;        Y: No Bytes  (odd) to checksum
0977 6CCC              ;        B: Set data bank reg to required bank.
0978 6CCC              ;
0979 6CCC              ; Output:
0980 6CCC              ;        C: Checksum of C to C+Y inclusive
0981 6CCC              ;
0982 6CCC              ;
0983 6CCC              ; Note:     Have partially computed checksum in C when
0984 6CCC              ;           dealing with more than one bank.
0985 6CCC              ;
0986 6CCC              ; kg nov85
0987 6CCC              ;...............................................................
0988 6CCC              CAL_CHECKSUM EQU   *                    ;Enter here first bank with C=0, else enter next line+1
0989 6CCC A9 00 00              LDA   #$0000                   ;Clear checksum to zero
0990 6CCF 18                    CLC   
0991 6CD0              CAL_CHECKSUM2 EQU   *                   ;Enter here for remaining banks.
0992 6CD0 88                    DEY                            ;rop to low byte of top address
0993 6CD1              N_NXT_CHK EQU   *
0994 6CD1 71 FD                 ADC   (CHK_BEG),Y              ;Add to previous value
0995 6CD3 88                    DEY                            ;ve to next byte
0996 6CD4 F0 03                 BEQ   CHK_END                  ;Fin except for last 2
0997 6CD6 88                    DEY                            ;ve to next byte
0998 6CD7 D0 F8                 BNE   N_NXT_CHK                ;do next two bytes
0999 6CD9              CHK_END  EQU   *
1000 6CD9 71 FD                 ADC   (CHK_BEG),Y              ;Add last 2 bytes
1001 6CDB 60                    RTS                            ;eturn in Native 16 mode
1002 6CDC                       EJECT 
1003 6CDC                       TITLE 'Cortland ROM Clock Test'
1004 6CDC              ;...............................................................
1005 6CDC              ; CLOCK
1006 6CDC              ; Test each bit in the clock register for R/W
1007 6CDC              ; Restore correct time after test.
1008 6CDC              ;
1009 6CDC              ;
1010 6CDC              ; Created :5 Mar 86, KG
1011 6CDC              ;
1012 6CDC              ; By Karl Grabe, Corcaig.   Apple Computer Ltd.
1013 6CDC              ;...............................................................
1014 6CDC
1015 6CDC                                                      ; SEG	RUNBANK
1016 6CDC              CLOCK    EQU   *
1017 6CDC F4 E1 E1              PEA   |$E1E1
1018 6CDF AB                    PLB   
1019 6CE0 AB                    PLB                            ;ank $E1
1020 6CE1              ;
1021 6CE1              ; Save time
1022 6CE1              ;
1023 6CE1 22 8C 00 E1           JSL   >TOREADTIME              ;Cad e an tam?
1024 6CE5 C2 30                 DATA16 
1025 6CE7 AD E1 03              LDA   |CLKRDATA                ;Get low binary time word
1026 6CEA 8D 00 09              STA   |BRAM_WORK               ;Save it here for retrieval after test
1027 6CED AD E3 03              LDA   |CLKRDATA+2              ;Get hi time word
1028 6CF0 8D 02 09              STA   |BRAM_WORK+2             ;Save it for after test
1029 6CF3              ;
1030 6CF3              ; Now setup CLKWDATA with 00000000 00000001
1031 6CF3              ; and shift thro' each bit
1032 6CF3              ;
1033 6CF3 A9 01 00              LDA   #$0001                   ;LSB
1034 6CF6 8D E5 03              STA   |CLKWDATA                ;Lo word
1035 6CF9 9C E7 03              STZ   |CLKWDATA+2              ;Hi word
1036 6CFC              NXT_CLK_BIT EQU   *                     ;Check next clock bit
1037 6CFC 20 2E 6D              JSR   |WR_RD_CMP_TIME          ;Write and see if correctly written
1038 6CFF F0 05                 BEQ   CLK_CONT                 ;Yes, so now check hi word
1039 6D01              ;Doesn't match, so repeat as a second may have incremented ...
1040 6D01 20 2E 6D              JSR   |WR_RD_CMP_TIME          ;Write and see if correctly written
1041 6D04 D0 26                 BNE   CLK_ERR                  ;Still doesn't match so we have an error
1042 6D06 AF E3 03 E1  CLK_CONT LDA   CLKRDATA+2               ;Now check hi word
1043 6D0A CD E7 03              CMP   |CLKWDATA+2
1044 6D0D D0 1D                 BNE   CLK_ERR                  ;No so there's an error
1045 6D0F 18                    CLC   
1046 6D10 2E E5 03              ROL   |CLKWDATA                ;If carry set then bit moves into hi word
1047 6D13 2E E7 03              ROL   |CLKWDATA+2              ;
1048 6D16 90 E4                 BCC   NXT_CLK_BIT              ;Not finished with 32 bits so continue
1049 6D18 AD 00 09              LDA   |BRAM_WORK               ;Now restore original time
1050 6D1B 8D E5 03              STA   |CLKWDATA
1051 6D1E AD 02 09              LDA   |BRAM_WORK+2
1052 6D21 8D E7 03              STA   |CLKWDATA+2              ;Restore hi word
1053 6D24 E2 30                 DATA8 
1054 6D26 22 88 00 E1           JSL   >TOWRITETIME
1055 6D2A 18                    CLC   
1056 6D2B 6B                    RTL   
1057 6D2C              CLK_ERR  EQU   *                        ;Fail handler
1058 6D2C 38                    SEC   
1059 6D2D 6B                    RTL   
1060 6D2E                       EJECT 
1061 6D2E              ;...............................................................
1062 6D2E              ; WR.RD.CMP.TIME  16/16
1063 6D2E              ;
1064 6D2E              ; Write, read back and compare write to read data
1065 6D2E              ; Z=1 if results equal ( ie good )
1066 6D2E              ;...............................................................
1067 6D2E
1068 6D2E              WR_RD_CMP_TIME EQU   *
1069 6D2E E2 30                 DATA8 
1070 6D30 22 88 00 E1           JSL   >TOWRITETIME             ;Write to clock
1071 6D34 22 8C 00 E1           JSL   >TOREADTIME              ;Now read back
1072 6D38 C2 30                 DATA16 
1073 6D3A AD E1 03              LDA   |CLKRDATA                ;Clock data read back
1074 6D3D CD E5 03              CMP   |CLKWDATA                ;Does it match what was written ?
1075 6D40 60                    RTS   
1076 6D41                       TITLE 'Text Pg1 shadow test'
1077 6D41              ;*****************************************************************
1078 6D41              *
1079 6D41              *   File  :  SHADOW
1080 6D41              *
1081 6D41              ;*****************************************************************
1082 6D41              *
1083 6D41              *
1084 6D41              *  This test checks shadow reg bit 0 (text page 1) by writing
1085 6D41              *  a known pattern , then  checking for the presence of this 
1086 6D41              *  pattern depending on the state of the shadow register.
1087 6D41              *
1088 6D41              *
1089 6D41              *   Modification history  :
1090 6D41              *
1091 6D41              *   10-Mar-86   :   JR  : Today
1092 6D41              *
1093 6D41              *   15-Apr-88   : BS Soh: Modify to test the shadowing of text page 2
1094 6D41              *                         for the Gyro
1095 6D41              *
1096 6D41              *   06-Feb-89   : MS Askins: Change Shadow.Tst so that it terminates
1097 6D41              *                         with an RTL (not RTS), fixed a stack problem,
1098 6D41              *                         code now returns with carry indicating whether
1099 6D41              *                         the call was successful.
1100 6D41              *
1101 6D41              ;*****************************************************************
1102 6D41                                                      ; SEG	$00	;Reflect data bank
1103 6D41
1104 6D41              SHADOW_TST EQU   *
1105 6D41 E2 30                 DATA8 
1106 6D43 9C 35 C0              STZ   SHADOW                   ;Shadow all
1107 6D46 A9 09                 LDA   #$09
1108 6D48 85 0E                 STA   ShdBit                   ;Test Shadowing of text page 1 first
1109 6D4A C2 30                 DATA16 
1110 6D4C A9 00 04              LDA   #$0400                   ;1st page starting address
1111 6D4F 20 AD 6D              JSR   ShdText                  ;Test Text Page 1
1112 6D52 B0 42                 BCS   Page1_Err
1113 6D54              ;
1114 6D54              ; Text Page 2 shadow test
1115 6D54              ;
1116 6D54 E2 30                 DATA8 
1117 6D56              ; Check key micro version number
1118 6D56              ;
1119 6D56 20 D8 6F              JSR   GETVERSION
1120 6D59 B0 4B                 BCS   s_fdb_err                ; problem reading up
1121 6D5B C9 06                 CMP   #$6                      ;Is version >= 6 ?
1122 6D5D B0 02                 BCS   GYROS                    ;Yes, is Gyro
1123 6D5F 80 34                 BRA   Shd_ret                  ; No, is gs, skip page 2 test & exit
1124 6D61 9C 35 C0     GYROS    STZ   SHADOW                   ;Shadow all
1125 6D64 A9 28                 LDA   #$28
1126 6D66 85 0E                 STA   ShdBit                   ;Test Shadowing of text page 2
1127 6D68 C2 30                 DATA16 
1128 6D6A A9 00 08              LDA   #$0800                   ;2nd page starting address
1129 6D6D 20 AD 6D              JSR   ShdText                  ;go test
1130 6D70 B0 28                 BCS   Page2_Err
1131 6D72                       LONGA OFF
1132 6D72                       LONGI OFF
1133 6D72              ;
1134 6D72              ; Testing CYA register Power-On-Clear bit (Bit 6)
1135 6D72              ;
1136 6D72 AD 36 C0              LDA   CYAREG                   ;Read CYA register
1137 6D75 48                    PHA                            ;ave it
1138 6D76 29 BF                 AND   #$BF                     ;Clear POC bit
1139 6D78 8D 36 C0              STA   CYAREG
1140 6D7B AD 36 C0              LDA   CYAREG                   ;Read back and check
1141 6D7E 29 40                 AND   #$40                     ;Bit 6 must be resetable
1142 6D80 D0 1C                 BNE   CYAREG_Err               ;Error
1143 6D82 AD 36 C0              LDA   CYAREG
1144 6D85 09 40                 ORA   #$40                     ;Set Bit 6
1145 6D87 8D 36 C0              STA   CYAREG
1146 6D8A AD 36 C0              LDA   CYAREG                   ;Read back and check
1147 6D8D 29 40                 AND   #$40
1148 6D8F F0 0D                 BEQ   CYAREG_Err               ;Error
1149 6D91 68                    PLA   
1150 6D92 8D 36 C0              STA   CYAREG                   ;Restore it
1151 6D95 6B           SHD_RET  RTL                            ;eturn to caller (end of shadow test)
1152 6D96              *
1153 6D96 A9 01        PAGE1_ERR LDA   #$01                    ;Page 1 error code
1154 6D98 80 0E                 BRA   epath
1155 6D9A              *
1156 6D9A A9 02        PAGE2_ERR LDA   #$02                    ;Page 2 error code
1157 6D9C 80 0A                 BRA   epath
1158 6D9E              *
1159 6D9E 68           CYAREG_ERR PLA                          ;Fix the stack
1160 6D9F 8D 36 C0              STA   CYAREG                   ;Restore it
1161 6DA2 A9 04                 LDA   #$04                     ;CYAREG POC bit error code
1162 6DA4 80 02                 BRA   epath
1163 6DA6              *
1164 6DA6 A9 03        S_FDB_ERR LDA   #$03                    ;FDB Call error code
1165 6DA8              EPATH    EQU   *
1166 6DA8 8D 16 03              STA   Tst_Status+1
1167 6DAB 38                    SEC   
1168 6DAC 6B                    RTL   
1169 6DAD              *
1170 6DAD              * Test one page of $400 byte beginning with addr specified by acc
1171 6DAD              *
1172 6DAD              SHDTEXT  EQU   *
1173 6DAD C2 30                 DATA16 
1174 6DAF 85 0A                 STA   ShdStrt                  ;Starting address of the page
1175 6DB1 64 0C                 STZ   ShdStrt+2
1176 6DB3 A9 5A 5A              LDA   #ShadPatt1
1177 6DB6 20 F9 6D              JSR   ShdWrite                 ;Write patt # 1 to bank $00
1178 6DB9 E6 0C                 INC   ShdStrt+2
1179 6DBB 20 F9 6D              JSR   ShdWrite                 ;Write patt # 1 to bank $01
1180 6DBE E2 20                 MEM8 
1181 6DC0 A5 0E                 LDA   ShdBit
1182 6DC2 8D 35 C0              STA   SHADOW                   ;Inhibit text shadowing
1183 6DC5 C2 10                 IND16 
1184 6DC7 A9 A5                 LDA   #ShadPatt2
1185 6DC9 8D 00 08              STA   ShdData
1186 6DCC 20 F9 6D              JSR   ShdWrite                 ;Write patt # 2 to bank $01
1187 6DCF C6 0C                 DEC   ShdStrt+2
1188 6DD1 20 F9 6D              JSR   ShdWrite                 ;Write patt # 2 to bank $00
1189 6DD4
1190 6DD4 20 06 6E              JSR   ShdVerfy                 ;Check bank $00
1191 6DD7 B0 1A                 BCS   C035_Bad
1192 6DD9 E6 0C                 INC   ShdStrt+2                ;Check bank $01
1193 6DDB 20 06 6E              JSR   ShdVerfy
1194 6DDE B0 13                 BCS   C035_Bad
1195 6DE0
1196 6DE0 A9 5A                 LDA   #ShadPatt1
1197 6DE2 8D 00 08              STA   ShdData
1198 6DE5 A9 E0                 LDA   #$00E0
1199 6DE7 85 0C                 STA   ShdStrt+2
1200 6DE9 20 06 6E              JSR   ShdVerfy                 ;Check bank $E0
1201 6DEC B0 05                 BCS   C035_Bad
1202 6DEE E6 0C                 INC   ShdStrt+2
1203 6DF0 20 06 6E              JSR   ShdVerfy                 ;Check bank $E1
1204 6DF3              C035_BAD EQU   *
1205 6DF3 E2 30                 DATA8 
1206 6DF5 9C 35 C0              STZ   SHADOW
1207 6DF8 60                    RTS   
1208 6DF9
1209 6DF9              *
1210 6DF9              *   'Write' a pattern routine
1211 6DF9              *
1212 6DF9
1213 6DF9                       LONGA ON
1214 6DF9                       LONGI ON
1215 6DF9 A0 00 00     SHDWRITE LDY   #$0000
1216 6DFC 97 0A        SHDSTORE STA   [ShdStrt],Y              ;Write directly to the bank
1217 6DFE C8                    INY   
1218 6DFF C8                    INY   
1219 6E00 C0 00 04              CPY   #ShdLenght               ;End of page ?
1220 6E03 D0 F7                 BNE   ShdStore
1221 6E05 60                    RTS   
1222 6E06
1223 6E06              *
1224 6E06              *  'Verify' the data in any Bank
1225 6E06              *
1226 6E06
1227 6E06 A0 00 00     SHDVERFY LDY   #$0000
1228 6E09 B7 0A        SHDFETCH LDA   [ShdStrt],Y              ;Load directly from the bank
1229 6E0B CD 00 08              CMP   ShdDATA
1230 6E0E D0 09                 BNE   ShdFail
1231 6E10 C8                    INY   
1232 6E11 C8                    INY   
1233 6E12 C0 00 04              CPY   #ShdLENGHT
1234 6E15 D0 F2                 BNE   ShdFetch
1235 6E17 18                    CLC   
1236 6E18 60                    RTS   
1237 6E19 38           SHDFAIL  SEC                            ;
1238 6E1A 60                    RTS   
1239 6E1B                       TITLE 'Vegas Battery Ram test'
1240 6E1B              ;...............................................................
1241 6E1B              ; BAT.RAM  (JSL)
1242 6E1B              ; ROM based Battery Ram Tests using Cortland tools
1243 6E1B              ;
1244 6E1B              ;
1245 6E1B              ; Errors: Carry Set,
1246 6E1B              ;         TST.STATUS+1 :  1=ADDRESS, TST.STATUS+2 = Failed address.
1247 6E1B              ;
1248 6E1B              ;         TST.STATUS+1 :  2=PATTTERN, TST.STATUS+2 = PATTERN
1249 6E1B              ;                                     TST.STATUS+3 = FAILED ADDRESS
1250 6E1B              ;
1251 6E1B              ;  Created: 04 Mar 86, KG
1252 6E1B              ;
1253 6E1B              ;  Karl Grabe. Apple Computer Ltd.  Cork.
1254 6E1B              ;...............................................................
1255 6E1B
1256 6E1B                                                      ; SEG	RUNBANK
1257 6E1B              BAT_RAM  EQU   *
1258 6E1B C2 30                 DATA16 
1259 6E1D A9 00 08              LDA   #BRAM_TEMP               ;Used to hold NVR contents suring test
1260 6E20 85 10                 STA   BAT_RAM_PTR              ;READ.NVR routine uses this
1261 6E22 64 12                 STZ   BAT_RAM_PTR+2            ;Upper two bytes of pointer
1262 6E24 20 A9 6E              JSR   READ_NVR                 ;Copy it to BRAM.TEMP
1263 6E27
1264 6E27              ;Now do address uniqueness test
1265 6E27                       LONGI OFF
1266 6E27                       LONGA OFF
1267 6E27 A0 FF                 LDY   #255                     ;Entire buffer
1268 6E29              NXT_BAT_ADR EQU   *
1269 6E29 98                    TYA   
1270 6E2A 99 FF 08              STA   |BRAM_WORK-1,Y           ;Store unique value in each addr
1271 6E2D 88                    DEY   
1272 6E2E D0 F9                 BNE   NXT_BAT_ADR              ;Do next bat ram address
1273 6E30 20 6D 6E              JSR   WR_RD_CMP                ;Write to Bram, read and compare
1274 6E33 B0 23                 BCS   BAT_RAM_ER2              ;Error so exit
1275 6E35 A2 05                 LDX   #5                       ;6 Patterns
1276 6E37 8E 27 03              STX   |CUR                     ;Use as temp storage
1277 6E3A              NXT_BAT_PAT EQU   *                     ;Do next battery pattern
1278 6E3A AE 27 03              LDX   |CUR                     ;Get counter back
1279 6E3D BF 8E 6E FF           LDA   >BAT_PAT,X
1280 6E41              ;
1281 6E41              ; FILL.BRAM.WORK
1282 6E41              ; Fill BRAM.WORK buffer with accumulator
1283 6E41              ;
1284 6E41              FILL_BRAM_WORK EQU   *
1285 6E41 A0 FF                 LDY   #255                     ;Entire buffer
1286 6E43              NXT_FILL_WORK EQU   *
1287 6E43 99 FF 08              STA   |BRAM_WORK-1,Y           ;Fill byte
1288 6E46 88                    DEY   
1289 6E47 D0 FA                 BNE   NXT_FILL_WORK
1290 6E49 20 6D 6E              JSR   WR_RD_CMP                ;Write to Bram, read then compare.
1291 6E4C B0 07                 BCS   BAT_RAM_ER1              ;Er so exit
1292 6E4E CE 27 03              DEC   |CUR                     ;Another Pattern ?
1293 6E51 10 E7                 BPL   NXT_BAT_PAT              ;Try another pattern
1294 6E53 80 0E                 BRA   GOOD_BAT_RAM             ;Restore Bram and exit
1295 6E55
1296 6E55 EE 16 03     BAT_RAM_ER1 INC   |TST_STATUS+1         ;Record error code
1297 6E58 EE 16 03     BAT_RAM_ER2 INC   |TST_STATUS+1         ;Rec er cd
1298 6E5B 8D 17 03              STA   |TST_STATUS+2            ;Address or pattern that failed
1299 6E5E 8C 18 03              STY   |TST_STATUS+3            ;Address of fail if pattern test
1300 6E61 38                    SEC                            ;rror flag
1301 6E62 6B                    RTL                            ;ack to sequencer
1302 6E63
1303 6E63              GOOD_BAT_RAM EQU   *                    ;Battery ram ok
1304 6E63 C2 30                 DATA16 
1305 6E65 A2 00 08              LDX   #BRAM_TEMP               ;Where we saved NVR initially
1306 6E68 20 94 6E              JSR   WRITE_NVR                ;Go restore NVR to what was there before test
1307 6E6B 18                    CLC                            ;lear error status
1308 6E6C 6B                    RTL                            ;.to sequencer
1309 6E6D              ;...............................................................
1310 6E6D              ; WR.RD.CMP  8/8
1311 6E6D              ; Write BRAM.WORK to Bram, read Bram to BRAM.WORK1
1312 6E6D              ; then copmare BRAM.WORK to BRAM.WORK1 
1313 6E6D              ;
1314 6E6D              ; Carry set if error,
1315 6E6D              ; A = Pattern that failed
1316 6E6D              ; Y = Address fail occurred
1317 6E6D              ;...............................................................
1318 6E6D              WR_RD_CMP EQU   *
1319 6E6D              ;
1320 6E6D              ; WR.BRAM.WORK
1321 6E6D              ;
1322 6E6D              ; Write BRAM.WORK to Bram
1323 6E6D              ;
1324 6E6D C2 30                 DATA16 
1325 6E6F A2 00 09              LDX   #BRAM_WORK               ;Save this buffer to bram
1326 6E72 20 94 6E              JSR   WRITE_NVR                ;Go save it
1327 6E75              ;
1328 6E75              ; RD.BRAM.WORK1
1329 6E75              ;
1330 6E75              ; Copy Bram into BRAM.WORK1
1331 6E75              ;
1332 6E75              RD_BRAM_WORK1 EQU   *
1333 6E75 A9 00 0A              LDA   #BRAM_WORK1              ;Now read back NVR into this buffer
1334 6E78 85 10                 STA   BAT_RAM_PTR              ;Tell READ.NVR routine where to read to
1335 6E7A 20 A9 6E              JSR   READ_NVR
1336 6E7D
1337 6E7D              ;
1338 6E7D              ; Now compare BRAM.WORK1 to BRAM.WORK
1339 6E7D              ;
1340 6E7D              CMP_BRAM_WORK EQU   *
1341 6E7D                       LONGA OFF
1342 6E7D                       LONGI OFF
1343 6E7D A0 FC                 LDY   #252                     ;But not checksum bytes (4)
1344 6E7F              NXT_CMP_WORK EQU   *
1345 6E7F B9 FF 08              LDA   |BRAM_WORK-1,Y           ;Bram
1346 6E82 D9 FF 09              CMP   |BRAM_WORK1-1,Y          ;Cortalnd ram
1347 6E85 D0 05                 BNE   BRAM_CMP_ER              ;No match so error
1348 6E87 88                    DEY   
1349 6E88 D0 F5                 BNE   NXT_CMP_WORK
1350 6E8A 18                    CLC                            ;ood status
1351 6E8B 60                    RTS   
1352 6E8C              BRAM_CMP_ER EQU   *                     ;Bad status
1353 6E8C 38                    SEC   
1354 6E8D 60                    RTS   
1355 6E8E AA 55 00 FF  BAT_PAT  DC B:$AA,$55,$00,$FF,$CC,$33
1356 6E94                       EJECT 
1357 6E94              ;...............................................................
1358 6E94              ; WRITE.NVR 16/16
1359 6E94              ; Write buffer pointed to by X to NVR
1360 6E94              ;
1361 6E94              ;...............................................................
1362 6E94                       LONGA ON
1363 6E94                       LONGI ON
1364 6E94              WRITE_NVR EQU   *
1365 6E94              ;X already set up
1366 6E94 A0 C0 02              LDY   #BRAMBUFFER              ;Normally in bank $e1
1367 6E97 A9 FF 00              LDA   #255                     ;All of buffer
1368 6E9A 54 E1 00              MVN   $000000,BRAMBUFFER       ;Move it into bank $e1
1369 6E9D E2 30                 DATA8 
1370 6E9F 22 80 00 E1           JSL   >TOWRITEBR               ;Go write it
1371 6EA3 20 FB 66              JSR   BANK_0                   ;Data bank = 0
1372 6EA6 C2 30                 DATA16 
1373 6EA8 60                    RTS   
1374 6EA9              ;...............................................................
1375 6EA9              ; READ.NVR XX/8
1376 6EA9              ; Copy NVR into a 4 byte buffer ppointed to by BAT.RAM.PTR
1377 6EA9              ;
1378 6EA9              ;...............................................................
1379 6EA9
1380 6EA9              READ_NVR EQU   *
1381 6EA9 E2 30                 DATA8 
1382 6EAB 8B                    PHB                            ;ave current data bank reg
1383 6EAC 08                    PHP                            ;ISABLE INTERRUPTS DURING WRITE
1384 6EAD 78                    SEI   
1385 6EAE A2 00                 LDX   #$00                     ;Start with 1st byte
1386 6EB0 9B                    TXY                            ;tart with address 00
1387 6EB1              READBRLP EQU   *
1388 6EB1 E2 40                 SEP   #$40                     ;Set v for read
1389 6EB3 20 C5 6E              JSR   XTNDBRAM                 ;Read a byte
1390 6EB6 5A                    PHY                            ;ave y
1391 6EB7 9B                    TXY   
1392 6EB8 97 10                 STA   [BAT_RAM_PTR],Y          ;Save for later
1393 6EBA 7A                    PLY                            ;ow restore y
1394 6EBB
1395 6EBB E8                    INX                            ;ext
1396 6EBC C8                    INY                            ;ext address
1397 6EBD D0 F2                 BNE   READBRLP
1398 6EBF
1399 6EBF 28                    PLP                            ;estore interrupt status
1400 6EC0 18                    CLC                            ;ata intact indicator
1401 6EC1 E2 30                 SEP   #$30                     ;M,X back to 8 bit mode
1402 6EC3 AB                    PLB                            ;estore data bank register
1403 6EC4 60                    RTS   
1404 6EC5
1405 6EC5              XTNDBRAM EQU   *                        ;Set up command and extended address
1406 6EC5 48                    PHA                            ;ave data to wr to clock register
1407 6EC6 98                    TYA                            ;reate extended address
1408 6EC7 48                    PHA                            ;ave for later
1409 6EC8 29 E0                 AND   #$E0                     ;Get sector data
1410 6ECA 4A                    LSR   A                        ;Move to bits 012
1411 6ECB 4A                    LSR   A
1412 6ECC 4A                    LSR   A
1413 6ECD 4A                    LSR   A
1414 6ECE 4A                    LSR   A
1415 6ECF 09 38                 ORA   #EXMEMCMD                ;Sets command corerectly ($38)
1416 6ED1 50 02                 BVC   XTNDBRAM4                ;V=0 then writing
1417 6ED3 09 80                 ORA   #$80                     ;Modify command for reading
1418 6ED5
1419 6ED5              XTNDBRAM4 EQU   *
1420 6ED5 EB                    XBA                            ;ove in hi byte of a
1421 6ED6 68                    PLA                            ;ecall adr
1422 6ED7 29 1F                 AND   #$1F                     ;Strip off sector bits
1423 6ED9 0A                    ASL   A                        ;Shift bits 2 to 6
1424 6EDA 0A                    ASL   A
1425 6EDB EB                    XBA                            ;ave address/do command
1426 6EDC 08                    PHP                            ;ave user read/write command
1427 6EDD 20 F4 6E              JSR   ACCCLKCLV                ;Transfer command to clock chip
1428 6EE0 EB                    XBA                            ;end address to write to, to clock chip
1429 6EE1              XTNDBRAM6 EQU   *
1430 6EE1 20 F4 6E              JSR   ACCCLKCLV                ;Transfer extended adr to clk chip
1431 6EE4 28                    PLP                            ;ecall what test sequencer wants
1432 6EE5 68                    PLA                            ;ecall sequencer data if writing
1433 6EE6 20 F5 6E              JSR   ACCCLOCK                 ;Read/write byte of data
1434 6EE9 48                    PHA   
1435 6EEA AD 34 C0              LDA   |CLOCKCTL                ;Reset bit
1436 6EED 29 DF                 AND   #$DF
1437 6EEF 8D 34 C0              STA   |CLOCKCTL
1438 6EF2 68                    PLA   
1439 6EF3 60                    RTS   
1440 6EF4
1441 6EF4              ACCCLKCLV EQU   *                       ;Write a byte of data to clock chip
1442 6EF4 B8                    CLV                            ;or write data
1443 6EF5              ACCCLOCK EQU   *                        ;Send a byte of data to the clock chip
1444 6EF5 8D 33 C0              STA   |CLOCKDATA               ;Data/address/cmd to clock data register
1445 6EF8 AD 34 C0              LDA   |CLOCKCTL                ;Reset read/write bit
1446 6EFB 29 3F                 AND   #$3F                     ;Bit 7/6 to 0
1447 6EFD 70 04                 BVS   ACCCLOCK0                ;V=1 IF READING
1448 6EFF 09 A0                 ORA   #$A0                     ;Bit 7/5 to 1 to write transfer
1449 6F01 80 02                 BRA   ACCCLOCK1
1450 6F03
1451 6F03              ACCCLOCK0 EQU   *                       ;Doing a read of battery ram if here
1452 6F03 09 E0                 ORA   #$E0                     ;Enable transfer for reading
1453 6F05              ACCCLOCK1 EQU   *                       ;
1454 6F05 8D 34 C0              STA   |CLOCKCTL                ;
1455 6F08              ACCCLOCK2 EQU   *                       ;Wait till transaction is done
1456 6F08 AD 34 C0              LDA   |CLOCKCTL                ;Wait for transfer to complete
1457 6F0B 30 FB                 BMI   ACCCLOCK2                ;Loop till done
1458 6F0D AD 33 C0              LDA   |CLOCKDATA               ;Data is in a on exit
1459 6F10 60                    RTS   
1460 6F11                       TITLE 'Cortland FDB test'
1461 6F11                       EJECT 
1462 6F11              ;...............................................................
1463 6F11              ; FDB
1464 6F11              ; Test the FDB processor rom
1465 6F11              ;
1466 6F11              ;
1467 6F11              ; Created : 27 Feb 86
1468 6F11              ; Modified : 19 Mar 86 for rom
1469 6F11              ; Modified : 10 Apr 86 use FDB tool call
1470 6F11              ; Modified :  5 Apr 88 for Gyro new keybd micro
1471 6F11              ;
1472 6F11              ; Routine to read FDB rom into main ram
1473 6F11              ; starting at FDB.BUF and then do a checksum.
1474 6F11              ;
1475 6F11              ; Call/RET: NTV16
1476 6F11              ;
1477 6F11              ; Output: Carry set if error, TST.STATUS+1,+2 CONTAINS BAD CHECKSUM                 
1478 6F11              ;
1479 6F11              ; By Karl Grabe Apple Computer Ltd., Cork by the Lee
1480 6F11              ;...............................................................
1481 6F11
1482 6F11              FDB      EQU   *
1483 6F11                                                      ; SEG	$00
1484 6F11 E2 30                 DATA8 
1485 6F13              ;
1486 6F13              ; Check key micro version number
1487 6F13              ;
1488 6F13 20 D8 6F              JSR   GETVERSION
1489 6F16 B0 59                 BCS   FDB_TOOL_ER              ;Tool had problem reading up
1490 6F18 C2 30                 DATA16 
1491 6F1A 29 FF 00              AND   #$FF                     ;Take away MS byte
1492 6F1D C9 06 00              CMP   #$6                      ;Is version >= 6 ?
1493 6F20 B0 05                 BCS   GYRO                     ;Yes, is Gyro
1494 6F22 A9 00 14              LDA   #FDB_ROM_B               ;Start address
1495 6F25 80 03                 BRA   SKIPNEXT
1496 6F27 A9 00 10     GYRO     LDA   #FDB_ROM_GYRO_A
1497 6F2A 8D 00 0B     SKIPNEXT STA   POINTER
1498 6F2D A9 04 0B              LDA   #FDB_BUF                 ;Where to stash in main mem
1499 6F30 85 10                 STA   BAT_RAM_PTR
1500 6F32 E2 30        NXT_FDB_BYTE DATA8 
1501 6F34 20 7D 6F              JSR   R_FDB                    ;Read a byte
1502 6F37 B0 38                 BCS   FDB_TOOL_ER              ;Tool had a problem reading up
1503 6F39 92 10                 STA   (BAT_RAM_PTR)            ;Save it
1504 6F3B C2 30                 DATA16 
1505 6F3D E6 10                 INC   BAT_RAM_PTR
1506 6F3F EE 00 0B              INC   POINTER                  ;FDB rom address
1507 6F42 AD 00 0B              LDA   POINTER
1508 6F45 C9 00 20              CMP   #FDB_ROM_E+1             ;Are we at end of rom yet ?
1509 6F48 30 E8                 BMI   NXT_FDB_BYTE
1510 6F4A              FDB_CHECK_TST EQU   *                   ;Debug entry point (NTV16)
1511 6F4A A9 04 0B              LDA   #FDB_BUF                 ;Start of address where FDB rom code is
1512 6F4D 85 FD                 STA   CHK_BEG
1513 6F4F AD 2B 03              LDA   KEY_VERSION              ;Get version number
1514 6F52 29 FF 00              AND   #$FF
1515 6F55 C9 06 00              CMP   #$6                      ;Is it >= 6?
1516 6F58 B0 05                 BCS   GYRO2                    ;Yes, Gyro
1517 6F5A A0 FF 0B              LDY   #FDB_ROM_E-FDB_ROM_B     ;End address
1518 6F5D 80 03                 BRA   SKIPNEXT2
1519 6F5F A0 FF 0F     GYRO2    LDY   #FDB_ROM_E-FDB_ROM_GYRO_A ;End address
1520 6F62 20 CC 6C     SKIPNEXT2 JSR   CAL_CHECKSUM            ;Go do checksum (data bank is zero)
1521 6F65 C9 72 F7              CMP   #FDB_REV2
1522 6F68 F0 05                 BEQ   FDB_GOOD_CHK             ;It's rev 2
1523 6F6A C9 72 26              CMP   #FDB_REV3                ;All other revs must equal this
1524 6F6D D0 07                 BNE   FDB_BAD
1525 6F6F              FDB_GOOD_CHK EQU   *
1526 6F6F 18                    CLC   
1527 6F70 6B                    RTL                            ;allable from disk diagnostics also
1528 6F71
1529 6F71                       LONGA OFF
1530 6F71                       LONGI OFF
1531 6F71              FDB_TOOL_ER EQU   *                     ;Tool had problem reading uC
1532 6F71 A9 01                 LDA   #1                       ;Tool problem
1533 6F73 8D 18 03              STA   TST_STATUS+3             ;Last byte of status
1534 6F76 8D 16 03     FDB_BAD  STA   TST_STATUS+1             ;The error tool encountered
1535 6F79 38                    SEC                            ;ad status
1536 6F7A 6B                    RTL   
1537 6F7B                       EJECT 
1538 6F7B                                                      ;****************************************
1539 6F7B              *
1540 6F7B              * Read a byte from the FDB Processor Memory (RAM/ROM)
1541 6F7B              *                      ... Don't use FDB Tool code
1542 6F7B              *
1543 6F7B              * Call: in 8 bit mode
1544 6F7B              * RTN : in 8 bit mode
1545 6F7B              *
1546 6F7B              * Inputs:
1547 6F7B              *        (POINTER) is byte to read
1548 6F7B              *        ROM in range $1400-1FFF
1549 6F7B              *        RAM in range $0000-0050
1550 6F7B              *
1551 6F7B              * Output:
1552 6F7B              *        ACC containes byte
1553 6F7B              *
1554 6F7B                                                      ;****************************************
1555 6F7B
1556 6F7B E2 30                 DATA8 
1557 6F7D A9 09        R_FDB    LDA   #%00001001               ;Command byte to read UP memory
1558 6F7F 20 9A 6F              JSR   FDB_CMD                  ;Do a store to FDB micro, rtn when ready
1559 6F82 B0 39                 BCS   ERR_RET                  ;Error sending command
1560 6F84 AD 00 0B              LDA   POINTER                  ;the low byte of rom start address
1561 6F87 20 9A 6F              JSR   FDB_CMD                  ;Store lo address
1562 6F8A B0 31                 BCS   ERR_RET                  ;Error sending command
1563 6F8C AD 01 0B              LDA   POINTER+1                ;Hi address
1564 6F8F 20 9A 6F              JSR   FDB_CMD                  ;Do hi
1565 6F92 B0 29                 BCS   ERR_RET                  ;Error sending command
1566 6F94 20 BF 6F              JSR   FDB_RDATA                ;Read data & wait till rdy
1567 6F97 B0 24                 BCS   ERR_RET                  ;Error sending command
1568 6F99 60                    RTS   
1569 6F9A
1570 6F9A
1571 6F9A              ;...............................................................
1572 6F9A              ; FDB.CMD
1573 6F9A              ; Write a byte to FDB processor
1574 6F9A              ;
1575 6F9A              ; Store acc in FDB command register and wait
1576 6F9A              ; 'till ready for next command/data
1577 6F9A              ;
1578 6F9A              ; Input Accumulator
1579 6F9A              ;
1580 6F9A              ; 8 bit mode
1581 6F9A              ;...............................................................
1582 6F9A
1583 6F9A              FDB_CMD  EQU   *
1584 6F9A C2 10                 IND16 
1585 6F9C 08                    PHP                            ;ave interrupt status
1586 6F9D 78                    SEI                            ;o interrupts
1587 6F9E AA                    TAX                            ;ave the command/data byte
1588 6F9F              ;@2 LDA DATAREG  ;DUMMY READ
1589 6F9F AD 27 C0              LDA   KMSTATUS                 ;Get status for command accept
1590 6FA2 6A                    ROR   A                        ;Put lsb in carry
1591 6FA3 8A                    TXA                            ;t data back
1592 6FA4              ;BCS @2
1593 6FA4 B0 14                 BCS   FDB_ERR                  ;BRA If register not empty, flag error !!
1594 6FA6 8D 26 C0              STA   DATAREG                  ;Else store away new command/data
1595 6FA9 A2 4C 1D              LDX   #7500                    ; Timeout 7500*(2+2+4+2+3)/3 = 30 ms
1596 6FAC CA           @1       DEX                            ;
1597 6FAD F0 0B                 BEQ   FDB_ERR                  ;Timeout error
1598 6FAF AD 27 C0              LDA   KMSTATUS                 ;Get command reg full bit
1599 6FB2 6A                    ROR   A                        ;Put lsb in carry
1600 6FB3 B0 F7                 BCS   @1
1601 6FB5 28                    PLP                            ;estore interrupt status
1602 6FB6 E2 10                 IND8 
1603 6FB8 18                    CLC                            ;'=0, o.k.
1604 6FB9 60                    RTS   
1605 6FBA 28           FDB_ERR  PLP                            ;
1606 6FBB E2 10                 IND8 
1607 6FBD 38           ERR_RET  SEC                            ;
1608 6FBE 60                    RTS   
1609 6FBF                       EJECT 
1610 6FBF              ;...............................................................
1611 6FBF              ; FDB.RDATA
1612 6FBF              ; Read a byte from FDB processor
1613 6FBF              ;
1614 6FBF              ; Read DATAREG register ( Wait till data valid )
1615 6FBF              ;
1616 6FBF              ; Output : Accumulator
1617 6FBF              ;
1618 6FBF              ; 8 bit mode
1619 6FBF              ;
1620 6FBF              ;...............................................................
1621 6FBF
1622 6FBF              FDB_RDATA EQU   *
1623 6FBF C2 10                 IND16 
1624 6FC1 08                    PHP                            ;ave interrupt status
1625 6FC2 78                    SEI                            ;o interupts allowed
1626 6FC3 A2 4C 1D              LDX   #7500
1627 6FC6 CA           @1       DEX                            ;
1628 6FC7 F0 F1                 BEQ   FDB_ERR                  ;Timeout error
1629 6FC9 AD 27 C0              LDA   KMSTATUS
1630 6FCC 29 20                 AND   #$20                     ;Data full?
1631 6FCE F0 F6                 BEQ   @1                       ;No, wait
1632 6FD0 AD 26 C0              LDA   DATAREG                  ;Get the FDB DATA
1633 6FD3 28                    PLP   
1634 6FD4 E2 10                 IND8 
1635 6FD6 18                    CLC   
1636 6FD7 60                    RTS   
1637 6FD8
1638 6FD8              ;...............................................................
1639 6FD8              ; Read the version number from key board micro
1640 6FD8              ;                        ... Don't use FDB Tools call
1641 6FD8              ;
1642 6FD8              ; Call: in 8 bit mode
1643 6FD8              ; Rtn; in 8 bit mode
1644 6FD8              ; Input: None
1645 6FD8              ;
1646 6FD8              ; Output:
1647 6FD8              ;   ACC contain version number
1648 6FD8              ;   KEY.VERSION contain version number
1649 6FD8              ;...............................................................
1650 6FD8
1651 6FD8              GETVERSION EQU   *
1652 6FD8 A9 0D                 LDA   #$0D                     ;Command to read kbmicro version number
1653 6FDA 20 9A 6F              JSR   FDB_CMD                  ;Send command to kb micro
1654 6FDD B0 DE                 BCS   ERR_RET                  ;Error sending command
1655 6FDF 20 BF 6F              JSR   FDB_RDATA                ;Read back data
1656 6FE2 B0 D9                 BCS   ERR_RET                  ;Error sending command
1657 6FE4 8D 2B 03              STA   KEY_VERSION
1658 6FE7 60                    RTS   
1659 6FE8
1660 6FE8                       TITLE 'New Ram Address Test'
1661 6FE8              ;**************************************************
1662 6FE8              *
1663 6FE8              * File: RAM.ADDR
1664 6FE8              *
1665 6FE8              * Routines to test the addressing of all onboard RAM
1666 6FE8              *  taking care to notice the Bank Address in the test.
1667 6FE8              *
1668 6FE8              *
1669 6FE8              *  20 Mar 86  R.Carr       New Today!
1670 6FE8              *
1671 6FE8              *  11 Nov 86  R.Montagne   Rewritten to fix access of
1672 6FE8              *                          bank0 softswitches when I/O
1673 6FE8              *                          shadowing is turned off.
1674 6FE8              *
1675 6FE8              *  18 May 88  BS Soh       Expanded to 1 M Ram for Rev D
1676 6FE8              *
1677 6FE8              *
1678 6FE8              ;**************************************************
1679 6FE8                                                      ; SEG	RUNBANK
1680 6FE8              RAM_ADDR EQU   *
1681 6FE8                                                      ; SEG	$00
1682 6FE8              DONEWADDR EQU   *
1683 6FE8              ;pea $00E1 ; data bank to E1 for softsw access
1684 6FE8              ;plb
1685 6FE8 E2 30                 DATA8 
1686 6FEA 20 D8 6F              JSR   GETVERSION
1687 6FED B0 60                 BCS   A_FDB_err                ;Tool had problem reading up
1688 6FEF AD 35 C0              LDA   |shadow                  ; preserve shadow register
1689 6FF2 48                    PHA   
1690 6FF3 A9 7F                 LDA   #%01111111               ; and turn shadowing off
1691 6FF5 8D 35 C0              STA   |shadow
1692 6FF8 A2 03                 LDX   #3                       ; pointer to bank under test
1693 6FFA BF F0 70 FF  WLP1     LDA   >Banktbl,x
1694 6FFE 85 F0                 STA   RamBank
1695 7000 85 06                 STA   loc+2
1696 7002 DA                    PHX                            ; save test bank pointer
1697 7003 C2 30                 REP   #$30                     ; 16 bit 'm' and 'x'
1698 7005                       LONGA ON
1699 7005                       LONGI ON
1700 7005 64 04                 STZ   loc                      ; sets up the indirection
1701 7007 A0 00 04              LDY   #$400                    ; start addr
1702 700A A2 FE BF              LDX   #$bffe                   ; end addr
1703 700D 20 C1 70              JSR   writeit                  ; fill mem with test pattern
1704 7010 E2 20                 SEP   #$20                     ; 8 bit 'm'
1705 7012 AD 8B C0              LDA   lcbank1                  ; R/W ram lc bank 1
1706 7015 AD 8B C0              LDA   lcbank1
1707 7018 C2 20                 REP   #$20                     ; 8 bit 'm'
1708 701A A0 00 D0              LDY   #$d000                   ; start address
1709 701D A2 FE FF              LDX   #$fffe                   ; end address
1710 7020 20 C1 70              JSR   writeit                  ; fill mem with test pattern
1711 7023 E2 30                 SEP   #$30                     ; 8 bit 'm' and 'x'
1712 7025                       LONGA OFF
1713 7025                       LONGI OFF
1714 7025 FA                    PLX                            ; restore test bank pointer
1715 7026 CA                    DEX   
1716 7027 10 D1                 BPL   wlp1
1717 7029              ;
1718 7029              ; Check key micro version number
1719 7029              ;
1720 7029 AD 2B 03              LDA   KEY_VERSION
1721 702C C9 06                 CMP   #$6                      ;Is version >= 6 ?
1722 702E 90 27                 BCC   IIGS                     ;No, it's IIgs
1723 7030 A9 01                 LDA   #$01
1724 7032 85 F0                 STA   RamBank
1725 7034 E6 F0        EXPBANK_A INC   RamBank                 ; Start with Bank $02
1726 7036 A5 F0                 LDA   RamBank
1727 7038 C9 10                 CMP   #$10                     ;Has it exceeded max?
1728 703A B0 1B                 BCS   IIgs                     ;Yes Exit
1729 703C 85 06                 STA   loc+2                    ; Setup bank number
1730 703E C2 30                 DATA16 
1731 7040 64 04                 STZ   loc                      ; Setup the indirection
1732 7042 A0 00 00              LDY   #0                       ; Start from 0
1733 7045 A2 FE FF              LDX   #$fffe                   ; End address
1734 7048 20 C1 70              JSR   writeit                  ; Fill memory with test pattern
1735 704B E2 20                 MEM8 
1736 704D 80 E5                 BRA   ExpBank_A                ; More Bank
1737 704F              ;
1738 704F A9 FF        A_FDB_ERR LDA   #$FF
1739 7051 8D 16 03              STA   ErrCode1
1740 7054 38                    SEC   
1741 7055 80 61                 BRA   NewAddrErr
1742 7057              ;
1743 7057 E2 10        IIGS     IND8 
1744 7059 A2 03                 LDX   #3                       ; pointer to bank under test
1745 705B BF F0 70 FF  CLP1     LDA   >BankTbl,x               ; get bank under test
1746 705F 85 F0                 STA   Rambank
1747 7061 85 06                 STA   loc+2
1748 7063 DA                    PHX   
1749 7064 C2 30                 REP   #$30                     ; 16 bit 'm' and 'x'
1750 7066                       LONGA ON
1751 7066                       LONGI ON
1752 7066 64 04                 STZ   loc                      ; preset address
1753 7068 A0 00 04              LDY   #$400                    ; start of addr check
1754 706B A2 FE BF              LDX   #$bffe                   ; end of addr check
1755 706E 20 D2 70              JSR   cmpit
1756 7071 B0 13                 BCS   CmpFail
1757 7073 E2 20                 SEP   #$20                     ; 8 bit 'm'
1758 7075 AD 8B C0              LDA   lcbank1                  ; R/W ram in LC bank 1
1759 7078 AD 8B C0              LDA   lcbank1
1760 707B C2 20                 REP   #$20                     ; 8 bit 'm'
1761 707D A0 00 D0              LDY   #$d000                   ; start address
1762 7080 A2 FE FF              LDX   #$fffe                   ; end address
1763 7083 20 D2 70              JSR   cmpit
1764 7086 E2 30        CMPFAIL  SEP   #$30                     ;carry is set on error
1765 7088                       LONGA OFF
1766 7088                       LONGI OFF
1767 7088 FA                    PLX                            ; restore pointer to test bank
1768 7089 B0 2D                 BCS   NewAddrErr
1769 708B CA                    DEX   
1770 708C 10 CD                 BPL   Clp1
1771 708E              ;
1772 708E              ; Check key micro version number
1773 708E              ;
1774 708E AD 2B 03              LDA   KEY_VERSION
1775 7091 C9 06                 CMP   #$6                      ;Is version >= 6 ?
1776 7093 90 23                 BCC   NewAddrErr               ;No, it's IIgs
1777 7095 A9 01                 LDA   #$01
1778 7097 85 F0                 STA   RamBank
1779 7099 E2 30        EXPBANK_B DATA8 
1780 709B E6 F0                 INC   RamBank                  ; Start with Bank $02
1781 709D A9 0F                 LDA   #$0F                     ;Maximum bank number
1782 709F C5 F0                 CMP   RamBank                  ;Has it exceeded max?
1783 70A1 90 15                 BCC   NewAddrErr               ;Yes Exit
1784 70A3 A5 F0                 LDA   RamBank
1785 70A5 85 06                 STA   loc+2                    ; Setup bank number
1786 70A7 C2 30                 DATA16 
1787 70A9 64 04                 STZ   loc                      ; Setup the indirection
1788 70AB A0 00 00              LDY   #0                       ; Start from 0
1789 70AE A2 FE FF              LDX   #$fffe                   ; End address
1790 70B1 20 D2 70              JSR   cmpit                    ; Compare it pattern
1791 70B4 90 E3                 BCC   ExpBank_B                ; More Bank
1792 70B6 E2 30                 DATA8 
1793 70B8              NEWADDRERR EQU   *
1794 70B8 68                    PLA                            ; restore shadow reg
1795 70B9 8F 35 C0 E0           STA   $E0C035                  ;real shadow location
1796 70BD              ;plb ; set bank back to 0
1797 70BD 2C 81 C0              BIT   |$C081                   ; turn the rom back on
1798 70C0 6B                    RTL   
1799 70C1              *
1800 70C1              WRITEIT  EQU   *
1801 70C1 86 F2                 STX   RamEndAddr
1802 70C3 BB           WRITELP1 TYX   
1803 70C4 98                    TYA   
1804 70C5 18                    CLC   
1805 70C6 65 F0                 ADC   RamBank
1806 70C8 9B                    TXY   
1807 70C9 97 04                 STA   [loc],y
1808 70CB C8                    INY   
1809 70CC C8                    INY   
1810 70CD C4 F2                 CPY   RamEndAddr
1811 70CF 90 F2                 BCC   writelp1
1812 70D1 60                    RTS   
1813 70D2              *
1814 70D2              CMPIT    EQU   *
1815 70D2 86 F2                 STX   RamEndAddr
1816 70D4 BB           CMPLP1   TYX   
1817 70D5 98                    TYA   
1818 70D6 18                    CLC   
1819 70D7 65 F0                 ADC   RamBank
1820 70D9 9B                    TXY   
1821 70DA D7 04                 CMP   [loc],y
1822 70DC D0 08                 BNE   cmperror
1823 70DE C8                    INY   
1824 70DF C8                    INY   
1825 70E0 C4 F2                 CPY   RamEndAddr
1826 70E2 90 F0                 BCC   cmplp1
1827 70E4 18                    CLC   
1828 70E5 60                    RTS   
1829 70E6              *
1830 70E6              CMPERROR EQU   *
1831 70E6 8D 16 03              STA   ErrCode1                 ;16 bit write is ok!
1832 70E9 98                    TYA                            ; as this covers it
1833 70EA EB                    XBA   
1834 70EB 8D 17 03              STA   ErrCode2
1835 70EE 38                    SEC   
1836 70EF 60                    RTS   
1837 70F0              *
1838 70F0              *
1839 70F0                                                      ; SEG	RUNBANK	;Table is in ROM
1840 70F0 00 01 E0 E1  BANKTBL  DC B:$0,$1,$E0,$E1             ;table of banks to check
